% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icr.R
\name{test_icr}
\alias{test_icr}
\title{Perform an intercoder reliability test}
\usage{
test_icr(data, unit_var, coder_var, ..., levels = NULL,
  na.omit = FALSE, agreement = TRUE, holsti = TRUE,
  kripp_alpha = TRUE, cohens_kappa = FALSE, fleiss_kappa = FALSE,
  brennan_prediger = FALSE)
}
\arguments{
\item{data}{a \link[tibble:tibble-package]{tibble}}

\item{unit_var}{Variable with unit identifiers}

\item{coder_var}{Variable with coder identifiers}

\item{...}{Variables to compute intercoder reliability estimates for. Leave
empty to compute for all variables (excluding \code{unit_var} and `coder_var``)
in data.}

\item{levels}{Optional named vector with levels of test variables}

\item{na.omit}{Logical indicating whether \code{NA} values should be stripped
before computation. Defaults to \code{FALSE}.}

\item{agreement}{Logical indicating whether simple percent agreement should
be computed. Defaults to \code{TRUE}.}

\item{holsti}{Logical indicating whether Holsti's reliability estimate
(mean pairwise agreement) should be computed. Defaults to \code{TRUE}.}

\item{kripp_alpha}{Logical indicating whether Krippendorff's Alpha should
be computed. Defaults to \code{TRUE}.}

\item{cohens_kappa}{Logical indicating whether Cohen's Kappa should
be computed. Defaults to \code{FALSE}.}

\item{fleiss_kappa}{Logical indicating whether Fleiss' Kappa should
be computed. Defaults to \code{FALSE}.}

\item{brennan_prediger}{Logical indicating whether Brennan & Prediger's Kappa
should be computed. Defaults to \code{FALSE}.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Performs an intercoder reliability test by computing various intercoder
reliability estimates for the included variables
}
\examples{
fbposts \%>\% test_icr(post_id, coder_id, pop_elite, pop_othering)
fbposts \%>\% test_icr(post_id, coder_id, levels = c(n_pictures = "ordinal"), fleiss_kappa = TRUE)

}
\seealso{
Other intercoder reliability: \code{\link{compute_icr}},
  \code{\link{icr_agreement}},
  \code{\link{icr_brennan_prediger}},
  \code{\link{icr_cohens_kappa}},
  \code{\link{icr_fleiss_kappa}},
  \code{\link{icr_holstis_CR}},
  \code{\link{icr_kripp_alpha}},
  \code{\link{unit_coder_matrix}}
}
\concept{intercoder reliability}
