% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/class-seg_basket.R,
%   R/class-seg_cpt.R, R/class-tidycpt.R, R/pkg-GA.R, R/pkg-changepoint.R,
%   R/pkg-wbs.R
\name{fitness}
\alias{fitness}
\alias{fitness.seg_basket}
\alias{fitness.seg_cpt}
\alias{fitness.tidycpt}
\alias{fitness.ga}
\alias{fitness.cpt}
\alias{fitness.wbs}
\title{Retrieve the optimal fitness (or objective function) value used by an
algorithm}
\usage{
fitness(object, ...)

\method{fitness}{seg_basket}(object, ...)

\method{fitness}{seg_cpt}(object, ...)

\method{fitness}{tidycpt}(object, ...)

\method{fitness}{ga}(object, ...)

\method{fitness}{cpt}(object, ...)

\method{fitness}{wbs}(object, ...)
}
\arguments{
\item{object}{A \code{segmenter} object.}

\item{...}{currently ignored}
}
\value{
A named \code{double} vector with the fitness value.
}
\description{
Retrieve the optimal fitness (or objective function) value used by an
algorithm
}
\details{
Segmenting algorithms use a \strong{fitness} metric, typically through the use of
a penalized objective function, to determine which changepoint sets are more
or less optimal.
This function returns the value of that metric for the changepoint set
implied by the object provided.
}
\examples{
# Segment a times series using a genetic algorithm
x <- segment(DataCPSim, method = "ga", maxiter = 10)

# Retrieve its fitness value
fitness(x)

# Segment a time series using Wild Binary Segmentation
x <- segment(DataCPSim, method = "wbs")

# Retrive its fitness
fitness(x)

}
\seealso{
Other tidycpt-generics: 
\code{\link{as.model}()},
\code{\link{as.segmenter}()},
\code{\link{changepoints}()},
\code{\link{diagnose}()},
\code{\link{model_name}()}

Other segmenter-functions: 
\code{\link{as.segmenter}()},
\code{\link{model_args}()},
\code{\link{seg_params}()}
}
\concept{segmenter-functions}
\concept{tidycpt-generics}
