% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ungather_draws.R, R/unspread_draws.R
\name{ungather_draws}
\alias{ungather_draws}
\alias{unspread_draws}
\title{Turn tidy data frames of variables from a Bayesian model back into untidy data}
\usage{
ungather_draws(data, ..., variable = ".variable", value = ".value",
  draw_indices = c(".chain", ".iteration", ".draw"),
  drop_indices = FALSE)

unspread_draws(data, ..., draw_indices = c(".chain", ".iteration",
  ".draw"), drop_indices = FALSE)
}
\arguments{
\item{data}{A tidy data frame of draws, such as one output by \code{spread_draws} or \code{gather_draws}.}

\item{...}{Expressions in the form of
\code{variable_name[dimension_1, dimension_2, ...]}. See \code{\link{spread_draws}}.}

\item{variable}{The name of the column in \code{data} that contains the names of variables from the model.}

\item{value}{The name of the column in \code{data} that contains draws from the variables.}

\item{draw_indices}{Character vector of column names in \code{data} that
should be treated as indices of draws. The default is \code{c(".chain",".iteration",".draw")},
which are the same names used for chain, iteration, and draw indices returned by
\code{\link{spread_draws}} or \code{\link{gather_draws}}.}

\item{drop_indices}{Drop the columns specified by \code{draw_indices} from the resulting data frame. Default \code{FALSE}.}
}
\value{
A data frame.
}
\description{
Inverse operations of \code{\link{spread_draws}} and \code{\link{gather_draws}}, giving
results that look like \code{\link{tidy_draws}}.
}
\details{
These functions take symbolic specifications of variable names and dimensions in the same format as
\code{\link{spread_draws}} and \code{\link{gather_draws}} and invert the tidy data frame back into
a data frame whose column names are variables with dimensions in them.
}
\examples{

library(dplyr)

data(RankCorr, package = "tidybayes")

# We can use unspread_draws to allow us to manipulate draws with tidybayes
# and then transform the draws into a form we can use with packages like bayesplot.
# Here we subset b[i,j] to just values of i in 1:2 and j == 1, then plot with bayesplot
RankCorr \%>\%
  spread_draws(b[i,j]) \%>\%
  filter(i \%in\% 1:2, j == 1) \%>\%
  unspread_draws(b[i,j], drop_indices = TRUE) \%>\%
  bayesplot::mcmc_areas()

# As another example, we could use compare_levels to plot all pairwise comparisons
# of b[1,j] for j in 1:3
RankCorr \%>\%
  spread_draws(b[i,j]) \%>\%
  filter(i == 1, j \%in\% 1:3) \%>\%
  compare_levels(b, by = j) \%>\%
  unspread_draws(b[j], drop_indices = TRUE) \%>\%
  bayesplot::mcmc_areas()

}
\seealso{
\code{\link{spread_draws}}, \code{\link{gather_draws}}, \code{\link{tidy_draws}}.
}
\author{
Matthew Kay
}
\keyword{manip}
