% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach_and_with.R
\name{attach}
\alias{attach}
\title{Attach an \code{edsurvey.data.frame} to Search Path}
\usage{
attach(
  what,
  pos = 2L,
  name = deparse1(substitute(what), backtick = FALSE),
  warn.conflicts = TRUE
)
}
\arguments{
\item{what}{equivalent to `what` in \code{base::attach}, but can also be an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}}

\item{pos}{equivalent to `pos` in \code{base::attach}}

\item{name}{equivalent to `name` in \code{base::attach}}

\item{warn.conflicts}{equivalent to `warn.conflicts` in \code{base::attach}}
}
\value{
the environment is returned invisibly with a "name" attribute
}
\description{
Implements \code{\link{attach}} for an \code{edsurvey.data.frame} or a \code{light.edsurvey.data.frame} by attaching student level variables to the search path
}
\details{
Because \code{attach} is a standard generic function that does not use method dispatch, we set this function as generic,
         which means it overwrites \code{base::attach} on loading. If the object to attach is not an \code{edsurvey.data.frame} or a \code{light.edsurvey.data.frame},
         the function will revert to the standard \code{base} method.
}
\seealso{
\ifelse{latex}{\code{attach}}{\code{\link[base:attach]{attach}}}
}
\author{
Blue Webb
}
