% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalogs.R
\encoding{UTF-8}
\name{bde_catalog_load}
\alias{bde_catalog_load}
\title{Load BdE catalogs}
\source{
\href{https://www.bde.es/webbde/en/estadis/infoest/descarga_series_temporales.html}{Time-series bulk data download}
}
\usage{
bde_catalog_load(
  catalog = "ALL",
  parse_dates = TRUE,
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{catalog}{A single value indicating the catalogs to be updated
or \code{"ALL"} as a shorthand. See \strong{Details}.}

\item{parse_dates}{Logical. If \code{TRUE} the dates would be parsed using
\code{\link[=bde_parse_dates]{bde_parse_dates()}}.}

\item{cache_dir}{A path to a cache directory. The directory can also be set
via options with \code{options(bde_cache_dir = "path/to/dir")}.}

\item{update_cache}{Logical. If \code{TRUE} the requested file would be updated on
the \code{cache_dir}.}

\item{verbose}{Logical \code{TRUE} or \code{FALSE}, display information useful for
debugging.}
}
\value{
A tibble
}
\description{
Load the time-series catalogs provided by BdE.
}
\details{
Accepted values for \code{catalog} are:\tabular{llll}{
   CODE \tab PUBLICATION \tab UPDATE FREQUENCY \tab FREQUENCY \cr
   BE \tab Statistical Bulletin \tab Daily \tab Monthly \cr
   CF \tab Financial Accounts of the Spanish Economy \tab Quarterly \tab Annual \cr
   IE \tab Economic Indicators \tab Daily \tab Monthly \cr
   SI \tab Summary Indicators \tab Daily \tab Daily \cr
   TC \tab Exchange Rates \tab Daily \tab Daily \cr
   TI \tab Interest Rates \tab Daily \tab Daily \cr
   PB \tab Bank Lending Survey \tab Quarterly \tab Quarterly \cr
}


Use \code{"ALL"} as a shorthand for updating all the catalogs at a glance.

If the requested catalog is not cached \code{\link[=bde_catalog_update]{bde_catalog_update()}} is invoked.
}
\examples{
\dontshow{if (bde_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
bde_catalog_load("TI", verbose = TRUE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other catalog: 
\code{\link{bde_catalog_search}()},
\code{\link{bde_catalog_update}()}
}
\concept{catalog}
