% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ithresh_methods.R
\name{summary.ithresh}
\alias{summary.ithresh}
\title{Summarizing measures of threshold predictive performance}
\usage{
\method{summary}{ithresh}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"ithresh"}, a result of a call to
\code{ithresh}.}

\item{...}{Additional optional arguments. At present no optional
arguments are used.}
}
\value{
Returns a numeric matrix with 5 columns and \code{n_v} rows,
  where \code{n_v} is an argument to \code{\link{ithresh}} that
  determines how many of the largest training thresholds are used
  a validation thresholds.  The columns contain:
\itemize{
  \item {column 1:} {the validation threshold v}
  \item {column 2:} {the sample quantile to which the validation threshold
    corresponds}
  \item {column 3:} {the best training threshold u judged using the
    validation threshold v}
  \item {column 4:} {the sample quantile to which the best training
    threshold corresponds}
  \item {column 5:} {the index of the vector \code{u_vec} of training
    thresholds to which the threshold in column2 corresponds}
}
}
\description{
\code{summary} method for class \code{"ithresh"}
}
\examples{
u_vec_gom <- quantile(gom, probs = seq(0, 0.9, by = 0.05))
gom_cv <- ithresh(data = gom, u_vec = u_vec_gom, n_v = 3)
summary(gom_cv)
}
\seealso{
\code{\link{ithresh}} for threshold selection in the i.i.d. case
  based on leave-one-out cross-validation.

\code{\link{plot.ithresh}} for the S3 plot method for objects of
  class \code{ithresh}.

\code{\link{print.ithresh}} Prints the threshold weights.
}
