% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computation.R
\name{simulate_sparse_matrix}
\alias{simulate_sparse_matrix}
\title{Generate a simulated sparse matrix}
\usage{
simulate_sparse_matrix(
  nrow,
  ncol,
  sparsity = 0.95,
  distribution_fun = function(n) stats::rpois(n, lambda = 0.5) + 1,
  decimal = 0,
  seed = 1
)
}
\arguments{
\item{nrow}{Number of rows in the matrix.}

\item{ncol}{Number of columns in the matrix.}

\item{sparsity}{Proportion of zero elements (sparsity level).
Default is \code{0.95}, meaning 95\% of elements are zero (5\% are non-zero).}

\item{distribution_fun}{Function to generate non-zero values.}

\item{decimal}{Controls the number of decimal places in the generated values.
If set to \code{0}, values will be integers.
When \code{decimal} > 0, random decimal parts are uniformly distributed across the full range.
Default is \code{0}.}

\item{seed}{Random seed for reproducibility.}
}
\value{
A sparse matrix of class "dgCMatrix".
}
\description{
This function generates a sparse matrix with a specified number of rows and columns,
a given sparsity level, and a distribution function for the non-zero values.
}
\examples{
simulate_sparse_matrix(1000, 500) |>
  check_sparsity()

simulate_sparse_matrix(10, 10, decimal = 1)
simulate_sparse_matrix(10, 10, decimal = 5)
}
