% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thames.R
\name{thames}
\alias{thames}
\title{THAMES estimator of the (reciprocal) log marginal likelihood}
\usage{
thames(
  lps = NULL,
  params,
  n_samples = NULL,
  d = NULL,
  radius = NULL,
  p = 0.025,
  q = 1 - p,
  lp_func = NULL,
  bound = NULL,
  n_simuls = 1e+05
)
}
\arguments{
\item{lps}{vector of unnormalized log posterior values of length n_samples (sum of the log prior and the log likelihood)}

\item{params}{matrix of parameter posterior samples of dimension n_samples * d}

\item{n_samples}{integer, number of posterior samples}

\item{d}{integer, dimension of parameter space}

\item{radius}{positive number, radius to use for defining the ellipsoid A}

\item{p}{percentile, used for lower bound of confidence interval}

\item{q}{percentile, used for upper bound of confidence interval}

\item{lp_func}{function to compute unnormalized log posterior values}

\item{bound}{function calculating membership of a point in the posterior support}

\item{n_simuls}{integer, number of Monte Carlo simulations
to use in the bounded parameter correction calculation.}
}
\value{
Returns a named list with the following elements:
}
\description{
This function computes the THAMES estimate of the reciprocal
    log marginal likelihood using posterior samples and
    unnormalized log posterior values.
}
\examples{
mu_star = 1
n <- 50
Y = rnorm(n, mu_star, 1)
sig2 <- 1
sig2_n <- 1/(n+1/sig2)
mn <- sum(Y)/(n + 1/sig2)
params <- rnorm(20, mean=mn,  (sig2_n))
lps <-  sapply(params, function(i){
sum(dnorm(Y,i,1,log = TRUE)) + dnorm(i,0,sig2, log = TRUE)})
thames(lps, params)


}
\references{
Metodiev M, Perrot-Dockès M, Ouadah S, Irons N. J., Raftery A. E.
    (2023) Easily Computed Marginal Likelihoods from Posterior Simulation
    Using the THAMES Estimator. arXiv preprint.
}
