% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_to_gt.R
\name{print_mock_gt}
\alias{print_mock_gt}
\title{Print mock table to GT}
\usage{
print_mock_gt(tfrmt, .data = NULL, .default = 1:3, n_cols = NULL)
}
\arguments{
\item{tfrmt}{tfrmt the mock table will be based off of}

\item{.data}{Optional data. If this is missing, group values, labels values
and parameter values will be estimated based on the tfrmt}

\item{.default}{sequence to replace the default values if a dataset isn't
provided}

\item{n_cols}{the number of columns. This will only be used if mock data isn't
provided. If not supplied, it will default to using the \code{col_plan} from the
\code{tfrmt}. If neither are available it will use 3.}
}
\value{
a stylized gt object
}
\description{
Print mock table to GT
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{
  # Create tfrmt specification
  tfrmt_spec <- tfrmt( label = label, column =
  column, param = param, body_plan = body_plan( frmt_structure(group_val =
  ".default", label_val = ".default", frmt_combine( "\{count\} \{percent\}",
  count = frmt("xxx"), percent = frmt_when("==100"~ frmt(""), "==0"~ "",
  "TRUE" ~ frmt("(xx.x\%)")))) ))

  # Print mock table using default
  print_mock_gt(tfrmt = tfrmt_spec)

}\if{html}{\out{</div>}}

\if{html}{\out{ <img src="https://raw.githubusercontent.com/GSK-Biostatistics/tfrmt/master/images/example_print_mock_gt1.png" alt = "Simple 3 by 3 table without values" style="width:50\%;"> }}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{  # Create mock data
  df <- crossing(label = c("label 1", "label 2",
  "label 3"), column = c("placebo", "trt1", "trt2"), param = c("count",
  "percent"))

  # Print mock table using mock data
  print_mock_gt(tfrmt_spec, df)

}\if{html}{\out{</div>}}

\if{html}{\out{ <img src="https://raw.githubusercontent.com/GSK-Biostatistics/tfrmt/master/images/example_print_mock_gt2.png" alt = "Simple 3 by 3 table without values, but with column names" style="width:50\%;"> }}
}

