% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frmt_utils.R
\name{is_frmt}
\alias{is_frmt}
\alias{is_frmt_combine}
\alias{is_frmt_when}
\alias{is_frmt_structure}
\alias{is_row_grp_structure}
\title{Check if input is a frmt}
\usage{
is_frmt(x)

is_frmt_combine(x)

is_frmt_when(x)

is_frmt_structure(x)

is_row_grp_structure(x)
}
\arguments{
\item{x}{Object to check}
}
\value{
'TRUE' if yes, 'FALSE' if no
}
\description{
Check if input is a frmt

Check if input is a frmt_combine

Check if input is a frmt_when

Check if input is a frmt_structure

Check if input is a row_grp_structure
}
\examples{
x1 <- frmt("XXX.XX")
is_frmt(x1)

x2 <- frmt_combine("XXX \%","XX,XXX")
is_frmt_combine(x2)

x2 <- frmt_when(
">3" ~ frmt("(X.X\%)"),
"<=3" ~ frmt("Undetectable")
)
is_frmt_when(x2)

x3 <- frmt_structure(
 group_val = c("group1"),
 label_val = ".default",
frmt("XXX")
)
is_frmt_structure(x3)

x4 <- row_grp_structure(group_val = c("A","C"), element_block(post_space = "---"))
is_row_grp_structure(x4)

}
