% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_beta_binomial}
\alias{tfd_beta_binomial}
\title{Beta-Binomial compound distribution}
\usage{
tfd_beta_binomial(
  total_count,
  concentration1,
  concentration0,
  validate_args = FALSE,
  allow_nan_stats = TRUE,
  name = "BetaBinomial"
)
}
\arguments{
\item{total_count}{Non-negative integer-valued tensor, whose dtype is the same
as \code{concentration1} and \code{concentration0}. The shape is broadcastable to
\verb{[N1,..., Nm]} with \code{m >= 0}. When \code{total_count} is broadcast with
\code{concentration1} and \code{concentration0}, it defines the distribution as a
batch of \verb{N1 x ... x Nm} different Beta-Binomial distributions. Its
components should be equal to integer values.}

\item{concentration1}{Positive floating-point \code{Tensor} indicating mean number of
successes. Specifically, the expected number of successes is
\code{total_count * concentration1 / (concentration1 + concentration0)}.}

\item{concentration0}{Positive floating-point \code{Tensor} indicating mean number of
failures; see description of \code{concentration1} for details.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
The Beta-Binomial distribution is parameterized by (a batch of) \code{total_count}
parameters, the number of trials per draw from Binomial distributions where
the probabilities of success per trial are drawn from underlying Beta
distributions; the Beta distributions are parameterized by \code{concentration1}
(aka 'alpha') and \code{concentration0} (aka 'beta').
Mathematically, it is (equivalent to) a special case of the
Dirichlet-Multinomial over two classes, although the computational
representation is slightly different: while the Beta-Binomial is a
distribution over the number of successes in \code{total_count} trials, the
two-class Dirichlet-Multinomial is a distribution over the number of successes
and failures.
}
\details{
Mathematical Details

The Beta-Binomial is a distribution over the number of successes in
\code{total_count} independent Binomial trials, with each trial having the same
probability of success, the underlying probability being unknown but drawn
from a Beta distribution with known parameters.
The probability mass function (pmf) is,\preformatted{pmf(k; n, a, b) = Beta(k + a, n - k + b) / Z
Z = (k! (n - k)! / n!) * Beta(a, b)
}

where:
\itemize{
\item \code{concentration1 = a > 0},
\item \code{concentration0 = b > 0},
\item \code{total_count = n}, \code{n} a positive integer,
\item \verb{n!} is \code{n} factorial,
\item \verb{Beta(x, y) = Gamma(x) Gamma(y) / Gamma(x + y)} is the
\href{https://en.wikipedia.org/wiki/Beta_function}{beta function}, and
\item \code{Gamma} is the \href{https://en.wikipedia.org/wiki/Gamma_function}{gamma function}.
}

Dirichlet-Multinomial is a \href{https://en.wikipedia.org/wiki/Compound_probability_distribution}{compound distribution},
i.e., its samples are generated as follows.
\enumerate{
\item Choose success probabilities:
\code{probs ~ Beta(concentration1, concentration0)}
\item Draw integers representing the number of successes:
\code{counts ~ Binomial(total_count, probs)}
Distribution parameters are automatically broadcast in all functions; see
examples for details.
}
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: 
\code{\link{tfd_autoregressive}()},
\code{\link{tfd_batch_reshape}()},
\code{\link{tfd_bates}()},
\code{\link{tfd_bernoulli}()},
\code{\link{tfd_beta}()},
\code{\link{tfd_binomial}()},
\code{\link{tfd_categorical}()},
\code{\link{tfd_cauchy}()},
\code{\link{tfd_chi2}()},
\code{\link{tfd_chi}()},
\code{\link{tfd_cholesky_lkj}()},
\code{\link{tfd_continuous_bernoulli}()},
\code{\link{tfd_deterministic}()},
\code{\link{tfd_dirichlet_multinomial}()},
\code{\link{tfd_dirichlet}()},
\code{\link{tfd_empirical}()},
\code{\link{tfd_exponential}()},
\code{\link{tfd_gamma_gamma}()},
\code{\link{tfd_gamma}()},
\code{\link{tfd_gaussian_process_regression_model}()},
\code{\link{tfd_gaussian_process}()},
\code{\link{tfd_generalized_normal}()},
\code{\link{tfd_geometric}()},
\code{\link{tfd_gumbel}()},
\code{\link{tfd_half_cauchy}()},
\code{\link{tfd_half_normal}()},
\code{\link{tfd_hidden_markov_model}()},
\code{\link{tfd_horseshoe}()},
\code{\link{tfd_independent}()},
\code{\link{tfd_inverse_gamma}()},
\code{\link{tfd_inverse_gaussian}()},
\code{\link{tfd_johnson_s_u}()},
\code{\link{tfd_joint_distribution_named_auto_batched}()},
\code{\link{tfd_joint_distribution_named}()},
\code{\link{tfd_joint_distribution_sequential_auto_batched}()},
\code{\link{tfd_joint_distribution_sequential}()},
\code{\link{tfd_kumaraswamy}()},
\code{\link{tfd_laplace}()},
\code{\link{tfd_linear_gaussian_state_space_model}()},
\code{\link{tfd_lkj}()},
\code{\link{tfd_log_logistic}()},
\code{\link{tfd_log_normal}()},
\code{\link{tfd_logistic}()},
\code{\link{tfd_mixture_same_family}()},
\code{\link{tfd_mixture}()},
\code{\link{tfd_multinomial}()},
\code{\link{tfd_multivariate_normal_diag_plus_low_rank}()},
\code{\link{tfd_multivariate_normal_diag}()},
\code{\link{tfd_multivariate_normal_full_covariance}()},
\code{\link{tfd_multivariate_normal_linear_operator}()},
\code{\link{tfd_multivariate_normal_tri_l}()},
\code{\link{tfd_multivariate_student_t_linear_operator}()},
\code{\link{tfd_negative_binomial}()},
\code{\link{tfd_normal}()},
\code{\link{tfd_one_hot_categorical}()},
\code{\link{tfd_pareto}()},
\code{\link{tfd_pixel_cnn}()},
\code{\link{tfd_poisson_log_normal_quadrature_compound}()},
\code{\link{tfd_poisson}()},
\code{\link{tfd_power_spherical}()},
\code{\link{tfd_probit_bernoulli}()},
\code{\link{tfd_quantized}()},
\code{\link{tfd_relaxed_bernoulli}()},
\code{\link{tfd_relaxed_one_hot_categorical}()},
\code{\link{tfd_sample_distribution}()},
\code{\link{tfd_sinh_arcsinh}()},
\code{\link{tfd_spherical_uniform}()},
\code{\link{tfd_student_t_process}()},
\code{\link{tfd_student_t}()},
\code{\link{tfd_transformed_distribution}()},
\code{\link{tfd_triangular}()},
\code{\link{tfd_truncated_cauchy}()},
\code{\link{tfd_truncated_normal}()},
\code{\link{tfd_uniform}()},
\code{\link{tfd_variational_gaussian_process}()},
\code{\link{tfd_vector_diffeomixture}()},
\code{\link{tfd_vector_exponential_diag}()},
\code{\link{tfd_vector_exponential_linear_operator}()},
\code{\link{tfd_vector_laplace_diag}()},
\code{\link{tfd_vector_laplace_linear_operator}()},
\code{\link{tfd_vector_sinh_arcsinh_diag}()},
\code{\link{tfd_von_mises_fisher}()},
\code{\link{tfd_von_mises}()},
\code{\link{tfd_weibull}()},
\code{\link{tfd_wishart_linear_operator}()},
\code{\link{tfd_wishart_tri_l}()},
\code{\link{tfd_wishart}()},
\code{\link{tfd_zipf}()}
}
\concept{distributions}
