% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts-functions.R
\name{sts_one_step_predictive}
\alias{sts_one_step_predictive}
\title{Compute one-step-ahead predictive distributions for all timesteps}
\usage{
sts_one_step_predictive(observed_time_series, model, parameter_samples)
}
\arguments{
\item{observed_time_series}{\code{float} \code{tensor} of shape
\verb{concat([sample_shape, model.batch_shape, [num_timesteps, 1]])} where
\code{sample_shape} corresponds to i.i.d. observations, and the trailing \verb{[1]}
dimension may (optionally) be omitted if \code{num_timesteps > 1}. May
optionally be an instance of \code{sts_masked_time_series}, which includes
a mask \code{tensor} to specify timesteps with missing observations.}

\item{model}{An instance of \code{StructuralTimeSeries} representing a
time-series model. This represents a joint distribution over
time-series and their parameters with batch shape \verb{[b1, ..., bN]}.}

\item{parameter_samples}{\code{list} of \code{tensors} representing posterior samples
of model parameters, with shapes
\verb{list(tf$concat(list(list(num_posterior_draws), param<1>$prior$batch_shape, param<1>$prior$event_shape), list(list(num_posterior_draws), param<2>$prior$batch_shape, param<2>$prior$event_shape), ... ) )}
for all model parameters.
This may optionally also be a named list mapping parameter names to \code{tensor} values.}
}
\value{
forecast_dist a \code{tfd_mixture_same_family} instance with event shape
\code{list(num_timesteps)} and batch shape \code{tf$concat(list(sample_shape, model$batch_shape))}, with
\code{num_posterior_draws} mixture components. The \code{t}th step represents the
forecast distribution \code{p(observed_time_series[t] | observed_time_series[0:t-1], parameter_samples)}.
}
\description{
Given samples from the posterior over parameters, return the predictive
distribution over observations at each time \code{T}, given observations up
through time \code{T-1}.
}
\seealso{
Other sts-functions: 
\code{\link{sts_build_factored_surrogate_posterior}()},
\code{\link{sts_build_factored_variational_loss}()},
\code{\link{sts_decompose_by_component}()},
\code{\link{sts_decompose_forecast_by_component}()},
\code{\link{sts_fit_with_hmc}()},
\code{\link{sts_forecast}()},
\code{\link{sts_sample_uniform_initial_state}()}
}
\concept{sts-functions}
