% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalar.R
\name{summary_scalar}
\alias{summary_scalar}
\title{Scalar event}
\usage{
summary_scalar(value, ..., metadata = NULL, tag = NA)
}
\arguments{
\item{value}{A numeric scalar value to be logged.}

\item{...}{Currently unused. To allow future expansion.}

\item{metadata}{A \code{metadata} object, as created with \code{\link[=summary_metadata]{summary_metadata()}}. In
most cases you don't need to change the default.}

\item{tag}{A tag that within the TensorBoard UI. See \code{\link[=log_event]{log_event()}} for other
ways of specifying the tag attribute.}
}
\value{
A \verb{<scalar_event>} object.
}
\description{
Scalar event
}
\examples{
temp <- tempfile()
with_logdir(temp, {
  log_event(loss = summary_scalar(1))
})
}
\seealso{
Other summary: 
\code{\link{summary_audio}()},
\code{\link{summary_histogram}()},
\code{\link{summary_image}()},
\code{\link{summary_text}()}
}
\concept{summary}
