% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_spec.R
\name{step_crossed_column}
\alias{step_crossed_column}
\title{Creates crosses of categorical columns}
\usage{
step_crossed_column(spec, ..., hash_bucket_size, hash_key = NULL)
}
\arguments{
\item{spec}{A feature specification created with \code{\link[=feature_spec]{feature_spec()}}.}

\item{...}{Comma separated list of variable names to apply the step. \link{selectors} can also be used.}

\item{hash_bucket_size}{An int > 1. The number of buckets.}

\item{hash_key}{(optional) Specify the hash_key that will be used by the
FingerprintCat64 function to combine the crosses fingerprints on
SparseCrossOp.}
}
\value{
a \code{FeatureSpec} object.
}
\description{
Use this step to create crosses between categorical columns.
}
\examples{
\dontrun{
library(tfdatasets)
data(hearts)
file <- tempfile()
writeLines(unique(hearts$thal), file)
hearts <- tensor_slices_dataset(hearts) \%>\% dataset_batch(32)

# use the formula interface
spec <- feature_spec(hearts, target ~ age) \%>\%
  step_numeric_column(age) \%>\%
  step_bucketized_column(age, boundaries = c(10, 20, 30))
spec_fit <- fit(spec)
final_dataset <- hearts \%>\% dataset_use_spec(spec_fit)
}
}
\seealso{
\link{steps} for a complete list of allowed steps.

Other Feature Spec Functions: 
\code{\link{dataset_use_spec}()},
\code{\link{feature_spec}()},
\code{\link{fit.FeatureSpec}()},
\code{\link{step_bucketized_column}()},
\code{\link{step_categorical_column_with_hash_bucket}()},
\code{\link{step_categorical_column_with_identity}()},
\code{\link{step_categorical_column_with_vocabulary_file}()},
\code{\link{step_categorical_column_with_vocabulary_list}()},
\code{\link{step_embedding_column}()},
\code{\link{step_indicator_column}()},
\code{\link{step_numeric_column}()},
\code{\link{step_remove_column}()},
\code{\link{step_shared_embeddings_column}()},
\code{\link{steps}}
}
\concept{Feature Spec Functions}
