% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgsub.R
\name{mgsub}
\alias{mgsub}
\alias{mgsub_fixed}
\alias{mgsub_regex}
\alias{mgsub_regex_safe}
\title{Multiple \code{\link[base]{gsub}}}
\usage{
mgsub(x, pattern, replacement, leadspace = FALSE, trailspace = FALSE,
  fixed = TRUE, trim = FALSE, order.pattern = fixed, safe = FALSE, ...)

mgsub_fixed(x, pattern, replacement, leadspace = FALSE, trailspace = FALSE,
  fixed = TRUE, trim = FALSE, order.pattern = fixed, safe = FALSE, ...)

mgsub_regex(x, pattern, replacement, leadspace = FALSE, trailspace = FALSE,
  fixed = FALSE, trim = FALSE, order.pattern = fixed, ...)

mgsub_regex_safe(x, pattern, replacement, ...)
}
\arguments{
\item{x}{A character vector.}

\item{pattern}{Character string to be matched in the given character vector.}

\item{replacement}{Character string equal in length to pattern or of length 
one which are a replacement for matched pattern.}

\item{leadspace}{logical.  If \code{TRUE} inserts a leading space in the 
replacements.}

\item{trailspace}{logical.  If \code{TRUE} inserts a trailing space in the 
replacements.}

\item{fixed}{logical. If \code{TRUE}, pattern is a string to be matched as is. 
Overrides all conflicting arguments.}

\item{trim}{logical.  If \code{TRUE} leading and trailing white spaces are 
removed and multiple white spaces are reduced to a single white space.}

\item{order.pattern}{logical.  If \code{TRUE} and \code{fixed = TRUE}, the 
\code{pattern} string is sorted by number of characters to prevent substrings 
replacing meta strings (e.g., \code{pattern = c("the", "then")} resorts to 
search for "then" first).}

\item{safe}{logical.  If \code{TRUE} then the \pkg{mgsub} package is used as
the backend and performs safe substitutions.  The trade-off is that this mode
will slow the replacements down considerably.}

\item{\dots}{Additional arguments passed to \code{\link[base]{gsub}}. In 
\code{mgsub_regex_safe} this is other arguments passed to \code{\link[mgsub]{mgsub}}.}
}
\value{
\code{mgsub} - Returns a vector with the pattern replaced.
}
\description{
\code{mgsub} - A wrapper for \code{\link[base]{gsub}} that takes a vector 
of search terms and a vector or single value of replacements.

\code{mgsub_fixed} - An alias for \code{mgsub}.

\code{mgsub_regex} - An wrapper for \code{mgsub} with \code{fixed = FALSE}.

\code{mgsub_regex_safe} - An wrapper for \code{\link[mgsub]{mgsub}}.
}
\examples{
mgsub(DATA$state, c("it's", "I'm"), c("it is", "I am"))
mgsub(DATA$state, "[[:punct:]]", "PUNC", fixed = FALSE)
\dontrun{
library(textclean)
hunthou <- replace_number(seq_len(1e5)) 

textclean::mgsub("'twenty thousand three hundred five' into 20305", hunthou, seq_len(1e5))
## "'20305' into 20305"

## Larger example from: https://stackoverflow.com/q/18332463/1000343
## A slower approach
fivehunthou <- replace_number(seq_len(5e5)) 

testvect <- c("fifty seven", "four hundred fifty seven", "six thousand four hundred fifty seven", 
    "forty six thousand four hundred fifty seven", "forty six thousand four hundred fifty seven", 
    "three hundred forty six thousand four hundred fifty seven"
)

textclean::mgsub(testvect, fivehunthou, seq_len(5e5))

## Safe substitution: Uses the mgsub package as the backend
dubious_string <- "Dopazamine is a fake chemical"
pattern <- c("dopazamin","do.*ne")
replacement <- c("freakout","metazamine")

mgsub(dubious_string, pattern, replacement, ignore.case = TRUE, fixed = FALSE)
mgsub(dubious_string, pattern, replacement, safe = TRUE, fixed = FALSE)
}
}
\seealso{
\code{\link[textclean]{replace_tokens}}
\code{\link[base]{gsub}}
}
