% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_1_textSimilarity.R
\name{textSimilarity}
\alias{textSimilarity}
\title{Compute the cosine semantic similarity between two text variables.}
\usage{
textSimilarity(x, y)
}
\arguments{
\item{x}{Word embeddings from textEmbed.}

\item{y}{Word embeddings from textEmbed.}
}
\value{
A vector comprising cosine semantic similarity scores.
}
\description{
Compute the cosine semantic similarity between two text variables.
}
\examples{
library(dplyr)
word_embeddings <- word_embeddings_4
similiarty_scores <- textSimilarity(word_embeddings$harmonytext, word_embeddings$satisfactiontext)
comment(similiarty_scores)
}
\seealso{
see \code{\link{textSimilarityNorm}} and \code{\link{textSimilarityTest}}
}
