% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_values.R
\name{count_values_funs}
\alias{count_values_funs}
\alias{count_values}
\alias{s_count_values}
\alias{s_count_values.character}
\alias{s_count_values.factor}
\alias{s_count_values.logical}
\alias{a_count_values}
\title{Count specific values}
\usage{
count_values(
  lyt,
  vars,
  values,
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  table_names = vars,
  .stats = "count_fraction",
  .formats = NULL,
  .labels = c(count_fraction = paste(values, collapse = ", ")),
  .indent_mods = NULL
)

s_count_values(
  x,
  values,
  na.rm = TRUE,
  .N_col,
  .N_row,
  denom = c("n", "N_row", "N_col")
)

\method{s_count_values}{character}(x, values = "Y", na.rm = TRUE, ...)

\method{s_count_values}{factor}(x, values = "Y", ...)

\method{s_count_values}{logical}(x, values = TRUE, ...)

a_count_values(
  x,
  values,
  na.rm = TRUE,
  .N_col,
  .N_row,
  denom = c("n", "N_row", "N_col")
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{values}{(\code{character})\cr specific values that should be counted.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table. Run \code{get_stats("count_values")}
to see available statistics for this function.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{na.rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{.N_col}{(\code{integer(1)})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}

\item{.N_row}{(\code{integer(1)})\cr row-wise N (row group count) for the group of observations being analyzed
(i.e. with no column-based subsetting) that is typically passed by \code{rtables}.}

\item{denom}{(\code{string})\cr choice of denominator for proportion. Options are:
\itemize{
\item \code{n}: number of values in this row and column intersection.
\item \code{N_row}: total number of values in this row across columns.
\item \code{N_col}: total number of values in this column across rows.
}}
}
\value{
\itemize{
\item \code{count_values()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_values()} to the table layout.
}

\itemize{
\item \code{s_count_values()} returns output of \code{\link[=s_summary]{s_summary()}} for specified values of a non-numeric variable.
}

\itemize{
\item \code{a_count_values()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

We can count the occurrence of specific values in a variable of interest.
}
\section{Functions}{
\itemize{
\item \code{count_values()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_count_values()}: S3 generic function to count values.

\item \code{s_count_values(character)}: Method for \code{character} class.

\item \code{s_count_values(factor)}: Method for \code{factor} class. This makes an automatic
conversion to \code{character} and then forwards to the method for characters.

\item \code{s_count_values(logical)}: Method for \code{logical} class.

\item \code{a_count_values()}: Formatted analysis function which is used as \code{afun}
in \code{count_values()}.

}}
\note{
\itemize{
\item For \code{factor} variables, \code{s_count_values} checks whether \code{values} are all included in the levels of \code{x}
and fails otherwise.
\item For \code{count_values()}, variable labels are shown when there is more than one element in \code{vars},
otherwise they are hidden.
}
}
\examples{
# `count_values`
basic_table() \%>\%
  count_values("Species", values = "setosa") \%>\%
  build_table(iris)

# `s_count_values.character`
s_count_values(x = c("a", "b", "a"), values = "a")
s_count_values(x = c("a", "b", "a", NA, NA), values = "b", na.rm = FALSE)

# `s_count_values.factor`
s_count_values(x = factor(c("a", "b", "a")), values = "a")

# `s_count_values.logical`
s_count_values(x = c(TRUE, FALSE, TRUE))

# `a_count_values`
a_count_values(x = factor(c("a", "b", "a")), values = "a", .N_col = 10, .N_row = 10)

}
