% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_rtables.R
\name{append_varlabels}
\alias{append_varlabels}
\title{Add Variable Labels to Top Left Corner in Table}
\usage{
append_varlabels(lyt, df, vars, indent = 0L)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{vars}{(\code{character})\cr variable names of which the labels are to be looked up in \code{df}.}

\item{indent}{(\code{integer})\cr non-negative number of nested indent space, default to 0L which means no indent.
1L means two spaces indent, 2L means four spaces indent and so on.}
}
\value{
A modified layout with the new variable label(s) added to the top-left material.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper layout creating function to just append the variable labels of a given variables vector
from a given dataset in the top left corner. If a variable label is not found then the
variable name itself is used instead. Multiple variable labels are concatenated with slashes.
}
\note{
This is not an optimal implementation of course, since we are using here the data set
itself during the layout creation. When we have a more mature \code{rtables} implementation then
this will also be improved or not necessary anymore.
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  split_rows_by("SEX") \%>\%
  append_varlabels(DM, "SEX") \%>\%
  analyze("AGE", afun = mean) \%>\%
  append_varlabels(DM, "AGE", indent = 1)
build_table(lyt, DM)

lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("SEX") \%>\%
  analyze("AGE", afun = mean) \%>\%
  append_varlabels(DM, c("SEX", "AGE"))
build_table(lyt, DM)

}
