% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pars.R
\name{pars.term}
\alias{pars.term}
\title{Parameter Names}
\usage{
\method{pars}{term}(x, scalar = NULL, terms = FALSE, ...)
}
\arguments{
\item{x}{An object.}

\item{scalar}{A flag specifying whether to by default return all parameters (NULL), or only scalar parameters (TRUE) or only non-scalar parameters (FALSE).}

\item{terms}{A flag specifying whether to return the parameter name
for each term element.}

\item{...}{Other arguments passed to methods.}
}
\value{
A character vector of the names of the parameters.
}
\description{
Gets the parameter names.
}
\examples{
term <- term(
  "alpha[1]", "alpha[2]", "beta[1,1]", "beta[2,1]",
  "beta[1,2]", "beta[2,2]", "sigma", NA
)
pars(term)
pars(term, scalar = TRUE)
pars(term, scalar = FALSE)
}
\seealso{
Other parameters: 
\code{\link{pars_terms}()}
}
\concept{parameters}
