% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify2.R
\name{classify2}
\alias{classify2}
\title{Perform tensor clustering via TBM method}
\usage{
classify2(x, k, r, l, lambda = 0, max.iter = 1000, threshold = 1e-15,
  trace = FALSE, Cs.init = NULL, Ds.init = NULL, Es.init = NULL,
  nstart = 20, method = "L0", center = FALSE)
}
\arguments{
\item{x}{a three-dimensional array}

\item{k}{\eqn{d_1}: the clusters number of mode 1}

\item{r}{\eqn{d_2}: the clusters number of mode 2}

\item{l}{\eqn{d_3}: the clusters number of mode 3}

\item{lambda}{a positive numeric value. The coefficient of the regularized term.}

\item{max.iter}{a positive integer. The Maximum times of iteration.}

\item{threshold}{a positive small numeric value which determines whether the algorithm converges or not.}

\item{trace}{logic value. If true, it would print the iteration situation.}

\item{Cs.init}{vector or NULL. Initial clsuter result of mode 1.}

\item{Ds.init}{vector or NULL. Initial clsuter result of mode 2.}

\item{Es.init}{vector or NULL. Initial clsuter result of mode 3.}

\item{nstart}{positive interger. The same as the "nstart" in kmeans().}

\item{method}{two options: "L0", "L1". Two methods use different penalties, where "L0" indicating L0 penalty and "L1" indicating Lasso penalty.}

\item{center}{logic value that indicates whether run "x = x-mean(x)" before performing clustering.}
}
\value{
a list   
\code{judgeX} estimated underlying mean signal.   

               \code{Cs} clustering result of mode 1.  
               
               \code{Ds} clustering result of mode 2.  
               
               \code{Es} clustering result of mode 3.  
               
               \code{mus} estimated underlying mean signal of each cluster.
}
\description{
This function performs sparse clustering on a three-dimensional tensor via TBM method.
}
\examples{
x = get.data(20,20,20,2,2,2)
classify2(x$x,2,2,2)
}
