% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{tcata.line.plot}
\alias{tcata.line.plot}
\title{Temporal Check-All-That-Apply (TCATA) curve}
\usage{
tcata.line.plot(X, n = 1, attributes = c(), times = c(),
lwd = 1, lty = 1, line.col = c(),
emphasis = NA, emphasis.col = c(), emphasis.lty = 1, emphasis.lwd = 3,
declutter = NA,
reference = NA, ref.col = c(), ref.lty = 2, ref.lwd = 1,
highlight = FALSE, highlight.col = c(), highlight.lty = 1, highlight.lwd = 5,
xlab = "Time", ylab = "Citation proportion", axes.font = 1,
axes.cex = 1, xlim = c(), las = 0,
x.increment = 5, box = FALSE,
legend.cex = 1, legend.font = 1, legend.pos = "topleft", legend.ncol = 2,
height = 8, width = 12, main = "",
save.format = "", save.as = "" )
}
\arguments{
\item{X}{matrix of proportions (or, if there is no missing data, on counts), typically with Attributes in rows and times in columns.}

\item{n}{The number of observations if \code{X} is a count matrix. Keep \code{n = 1} if \code{X} is a matrix of proportions.}

\item{attributes}{a vector of attribute labels, corresponding to the attributes in \code{X}.}

\item{times}{a vector of time, corresponding to the times in \code{X}.}

\item{lwd}{line width for attribute curves in \code{X} or matrix of line widths that is the same size as \code{X}.}

\item{lty}{line types for attribute curves in \code{X} or matrix of line types that is the same size as \code{X}.}

\item{line.col}{vector of colors for lines corresponding to rows of \code{X}.}

\item{emphasis}{a matrix matching \code{X} in its dimensions, with a numeric value corresponding to points requiring emphasis, and \code{NA} for points without emphasis.}

\item{emphasis.col}{vector colours for attributes corresponding to rows of \code{X}; taken from \code{line.col} if not specified.}

\item{emphasis.lty}{either a line type (\code{lty}) for all emphasis lines .}

\item{emphasis.lwd}{line weight associated with the emphasis line.}

\item{declutter}{a matrix with the same dimensions as \code{X}; give the value \code{1} to show a proportion in \code{X} and \code{reference} (if given), otherwise give \code{0} or \code{NA}.}

\item{reference}{a matrix with the same dimensions as \code{X}; give the value \code{1} if \code{reference} will be shown (allowing finer control than \code{declutter}), otherwise give \code{0} or \code{NA}.}

\item{ref.col}{\code{reference} line colour.}

\item{ref.lty}{\code{reference} line type.}

\item{ref.lwd}{\code{reference} line width.}

\item{highlight}{a matrix matching \code{X} in its dimensions, with a numeric value corresponding to points requiring highlighting, and \code{NA} for points without highlighting}

\item{highlight.col}{a vector of colours for attributes corresponding to rows of \code{X}.}

\item{highlight.lty}{line type associated with the highlighting.}

\item{highlight.lwd}{line weight associated with the highlighting line.}

\item{xlab}{label for the x axis.}

\item{ylab}{label for the y axis.}

\item{axes.font}{font for axes labels; see \code{\link[graphics]{par}}.}

\item{axes.cex}{size for axes labels.}

\item{xlim}{x limits specified using a vector of 2 (ascending) numbers.}

\item{las}{numeric in {0,1,2,3}; the style of the axis labels. See \code{\link[graphics]{par}}.}

\item{x.increment}{interval between times when labelling the x axis.}

\item{box}{draw box around plot area; see: \code{\link[graphics]{box}}}

\item{legend.cex}{size of markers shown in the legend.}

\item{legend.font}{font for the legend; see \code{\link[graphics]{text}}.}

\item{legend.pos}{location of plot legend; defaults to \code{"topleft"}.}

\item{legend.ncol}{number of columns in legend.}

\item{height}{window height.}

\item{width}{window width.}

\item{main}{plot title; see \code{\link[graphics]{plot}}.}

\item{save.format}{If indicated, this will be the fle type for the save image. Defaults to \code{"eps"} (eps format). Other possible values are \code{""} (not saved) or \code{"png"} (png format).}

\item{save.as}{Filename if the file will be saved.}
}
\description{
Plots TCATA curves based on count or proportion data. Can also be used for plotting Temporal Dominance of Sensations (TDS) curves based on dominance counts or proportions.
}
\examples{
# example using 'syrah' data set
low1 <- t(syrah[seq(3, 1026, by = 6), -c(1:4)])
colnames(low1) <- 10:180
tcata.line.plot(get.smooth(low1), lwd = 2, main = "Low-ethanol wine (Sip 1)")

# example using 'ojtcata' data set
data(ojtcata)
x <- aggregate(ojtcata[, -c(1:4)], list(samp = ojtcata$samp, attribute = ojtcata$attribute), sum)
p.1.checked <- x[x$samp == 1, -c(1:2)]
p.1.eval <- length(unique(ojtcata$cons))
p.not1.checked <- aggregate(x[, -c(1:2)], list(attribute = x$attribute), sum)[, -1]
p.not1.eval <- length(unique(ojtcata$cons)) * (length(unique(ojtcata$samp)) - 1)

# reference lines for contrast products
p.1.refline <- p.not1.checked / p.not1.eval
# decluttering matrix corresponds to the dimensions of p.1.refline
p.1.declutter <- matrix(get.decluttered(x = unlist(p.1.checked), n.x = p.1.eval,
                                        y = unlist(p.not1.checked), n.y = p.not1.eval),
                        nrow = nrow(p.1.checked))
times <- get.times(colnames(x)[-c(1:2)])
attributes <- unique(x$attribute)
palettes <- make.palettes(length(attributes))
tcata.line.plot(p.1.checked, n = p.1.eval, attributes = attributes, times = times,
                line.col = palettes$pal, reference = p.1.refline, ref.lty = 3,
                declutter = p.1.declutter,
                highlight = TRUE, highlight.lwd = 4,
                highlight.col = palettes$pal.light,
                height = 7, width = 11, legend.cex = 0.7, main = "Sample 1")

# example showing plots similar to those in Meyners & Castura (2018)
p.all.checked <- aggregate(x[, -c(1:2)], list(attribute = x$attribute), sum)[, -1]
p.all.eval <- length(unique(ojtcata$cons)) * length(unique(ojtcata$samp))
lty.mat <- matrix(1,nrow=6,ncol=21)
lty.mat[, 1:3] <- c(rep(NA,8),rep(c(1,NA),4), 1, 1)
lty.mat[2, 9:12] <- lty.mat[5, 8] <- 3
tcata.line.plot(p.1.checked, n = p.1.eval, attributes = attributes, times = times,
                line.col = palettes$pal, lty = lty.mat, lwd = 2,
                height = 7, width = 11, legend.cex = 0.7, main = "Sample 1")
}
\references{
Castura, J.C., Antúnez, L., Giménez, A., Ares, G. (2016). Temporal check-all-that-apply (TCATA): A novel temporal sensory method for characterizing products. \emph{Food Quality and Preference}, 47, 79-90. \doi{10.1016/j.foodqual.2015.06.017}

Meyners, M., Castura, J.C. (2018). The analysis of temporal check-all-that-apply (TCATA) data. \emph{Food Quality and Preference}, 67, 67-76. \doi{10.1016/j.foodqual.2017.02.003}
}
