% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stEval.R
\name{stEval}
\alias{stEval}
\title{Basic evaluation of fit}
\usage{
stEval(forecast, Y, clim)
}
\arguments{
\item{forecast}{stPredict object containing predictions for Y}

\item{Y}{observed values of the response}

\item{clim}{the climatology for the location in Y}
}
\description{
Provides basic measures for evalutating the fit.  Includes Brier skill score
against the climatology, MSPE, PPL, overall correlation, and a computation
of the coverage probabilities for confidence intervals
}
\examples{

data("coprecip")
data("coprecip.predict")

clim = rowMeans(coprecip$Y)
coprecip.predict = stEval(coprecip.predict, coprecip$Y, clim)

}
