% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tleaves.R
\name{.get_Dx}
\alias{.get_Dx}
\title{D_x: Calculate diffusion coefficient for a given temperature and pressure}
\usage{
.get_Dx(D_0, Temp, eT, P, unitless)
}
\arguments{
\item{D_0}{Diffusion coefficient at 273.15 K (0 °C) and 101.3246 kPa}

\item{Temp}{Temperature in Kelvin}

\item{eT}{Exponent for temperature dependence of diffusion}

\item{P}{Atmospheric pressure in kPa}

\item{unitless}{Logical. Should function use parameters with \code{units}? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}
}
\value{
Value in m\eqn{^2}/s of class \code{units}
}
\description{
D_x: Calculate diffusion coefficient for a given temperature and pressure
}
\details{
\deqn{D = D_\mathrm{0} (T / 273.15) ^ {eT} (101.3246 / P)}{D = D_0 [(T / 273.15) ^ eT] (101.3246 / P)}
\cr
According to Montieth & Unger (2013), eT is generally between 1.5 and 2. Their data in Appendix 3 indicate \eqn{eT = 1.75} is reasonable for environmental physics.
}
\examples{

tealeaves:::.get_Dx(
  D_0 = set_units(2.12e-05, m^2/s),
  Temp = set_units(298.15, K),
  eT = set_units(1.75),
  P = set_units(101.3246, kPa),
  unitless = FALSE
)

}
\references{
Monteith JL, Unsworth MH. 2013. Principles of Environmental Physics. 4th edition. Academic Press, London.
}
