% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_slices.R
\name{teal_slices}
\alias{teal_slices}
\title{Complete filter specification}
\usage{
teal_slices(
  ...,
  exclude_varnames = NULL,
  include_varnames = NULL,
  count_type = NULL,
  allow_add = TRUE
)
}
\arguments{
\item{...}{any number of \code{teal_slice} objects.}

\item{include_varnames, exclude_varnames}{(\verb{named list}s of \code{character}) where list names
match names of data sets and vector elements match variable names in respective data sets;
specify which variables are allowed to be filtered; see \code{Details}.}

\item{count_type}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\emph{This is a new feature. Do kindly share your opinions on
\href{https://github.com/insightsengineering/teal.slice/}{\code{teal.slice}'s GitHub repository}.}

(\code{character(1)}) string specifying how observations are tallied by these filter states.
Possible options:
\itemize{
\item \code{"none"} (default) to have counts of single \code{FilterState} to show unfiltered number only.
\item \code{"all"} to have counts of single \code{FilterState} to show number of observation in filtered
and unfiltered dataset. Note, that issues were reported when using this option with \code{MultiAssayExperiment}.
Please make sure that adding new filters doesn't fail on target platform before deploying for production.
}}

\item{allow_add}{(\code{logical(1)}) logical flag specifying whether the user will be able to add new filters}
}
\value{
\code{teal_slices}, which is an unnamed list of \code{teal_slice} objects.
}
\description{
Create \code{teal_slices} object to package multiple filters and additional settings.
Check out \code{\link{teal_slices-utilities}} functions for working with \code{teal_slices} object.
}
\details{
\code{teal_slices()} collates multiple \code{teal_slice} objects into a \code{teal_slices} object,
a complete filter specification. This is used by all classes above \code{FilterState}
as well as \code{filter_panel_api} wrapper functions.
\code{teal_slices} has attributes that modify the behavior of the filter panel, which are resolved by different classes.

\code{include_varnames} and \code{exclude_varnames} determine which variables can have filters assigned.
The former enumerates allowed variables, the latter enumerates forbidden values.
Since these could be mutually exclusive, it is impossible to set both allowed and forbidden
variables for one data set in one \code{teal_slices}.
}
\examples{
filter_1 <- teal_slice(
  dataname = "dataname1",
  varname = "varname1",
  choices = letters,
  selected = "b",
  keep_na = TRUE,
  fixed = FALSE,
  extra1 = "extraone"
)
filter_2 <- teal_slice(
  dataname = "dataname1",
  varname = "varname2",
  choices = 1:10,
  keep_na = TRUE,
  selected = 2,
  fixed = TRUE,
  anchored = FALSE,
  extra2 = "extratwo"
)
filter_3 <- teal_slice(
  dataname = "dataname2",
  varname = "varname3",
  choices = 1:10 / 10,
  keep_na = TRUE,
  selected = 0.2,
  fixed = TRUE,
  anchored = FALSE,
  extra1 = "extraone",
  extra2 = "extratwo"
)

all_filters <- teal_slices(
  filter_1,
  filter_2,
  filter_3,
  exclude_varnames = list(
    "dataname1" = "varname2"
  )
)

is.teal_slices(all_filters)
all_filters[1:2]
c(all_filters[1], all_filters[2])
print(all_filters)
print(all_filters, trim_lines = FALSE)

}
\seealso{
\itemize{
\item \code{\link{teal_slice}} for creating constituent elements of \code{teal_slices}
\item \code{\link[teal:slices_store]{teal::slices_store}} for robust utilities for saving and loading \code{teal_slices} in \code{JSON} format
\item \code{\link{is.teal_slices}}, \code{\link{as.teal_slices}}, \code{\link{as.list.teal_slices}}, [\verb{[.teal_slices}], \code{\link{c.teal_slices}}
\code{\link{print.teal_slices}}, \code{\link{format.teal_slices}}
}
}
