% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{shared_params}
\alias{shared_params}
\title{Shared parameters documentation}
\arguments{
\item{plot_height}{(\code{numeric}) optional, specifies the plot height as a three-element vector of
\code{value}, \code{min}, and \code{max} intended for use with a slider UI element.}

\item{plot_width}{(\code{numeric}) optional, specifies the plot width as a three-element vector of
\code{value}, \code{min}, and \code{max} for a slider encoding the plot width.}

\item{rotate_xaxis_labels}{(\code{logical}) optional, whether to rotate plot X axis labels. Does not
rotate by default (\code{FALSE}).}

\item{ggtheme}{(\code{character}) optional, \code{ggplot2} theme to be used by default. Defaults to \code{"gray"}.}

\item{ggplot2_args}{(\code{ggplot2_args}) object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}}
with settings for the module plot.
The argument is merged with options variable \code{teal.ggplot2_args} and default module setup.

For more details see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}}

\item{basic_table_args}{(\code{basic_table_args}) object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table.
The argument is merged with options variable \code{teal.basic_table_args} and default module setup.

For more details see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}}

\item{pre_output}{(\code{shiny.tag}) optional, text or UI element to be displayed before the module's output,
providing context or a title.
with text placed before the output to put the output into context. For example a title.}

\item{post_output}{(\code{shiny.tag}) optional, text or UI element to be displayed after the module's output,
adding context or further instructions. Elements like \code{shiny::helpText()} are useful.}

\item{alpha}{(\code{integer(1)} or \code{integer(3)}) optional, specifies point opacity.
\itemize{
\item When the length of \code{alpha} is one: the plot points will have a fixed opacity.
\item When the length of \code{alpha} is three: the plot points opacity are dynamically adjusted based on
vector of \code{value}, \code{min}, and \code{max}.
}}

\item{size}{(\code{integer(1)} or \code{integer(3)}) optional, specifies point size.
\itemize{
\item When the length of \code{size} is one: the plot point sizes will have a fixed size.
\item When the length of \code{size} is three: the plot points size are dynamically adjusted based on
vector of \code{value}, \code{min}, and \code{max}.
}}
}
\value{
Object of class \code{teal_module} to be used in \code{teal} applications.
}
\description{
Defines common arguments shared across multiple functions in the package
to avoid repetition by using \code{inheritParams}.
}
\keyword{internal}
