ui = fluidPage(theme = add_theme(getShinyOption('theme')), 
               add_css(),
               
sidebarLayout(
  sidebarPanel(width = 3, 
     hr(), 
     sliderInput("range.bin", 
                 label = "Range:",
                 min = 0, 
                 max = 50, 
                 step = 1,
                 value = c(0,10)),
     hr(),
     sliderInput("n.bin", 
                 label = "Observations",
                 min = 0, 
                 max = 50, 
                 step = 1, 
                 value = 5), 
     hr(), 
     sliderInput("prob.bin", 
                 label = "Probability",
                 min = .05, 
                 max = 1, 
                 step=.05, 
                 value = .05,
                 animate=TRUE)), 

   mainPanel(width = 9, 
       tabsetPanel(type = "pills", 
             tabPanel("Distribution Function", 
                      metricsgraphicsOutput(height = "550px", "binC")), 
             tabPanel("Density",
                      metricsgraphicsOutput(height = "550px", "binP")), 
             tabPanel("Survival", 
                      metricsgraphicsOutput(height = "550px", "binR")), 
             tabPanel("Hazard", 
                      metricsgraphicsOutput(height = "550px", "binh")), 
             tabPanel("Cumulative Hazard", 
                      metricsgraphicsOutput(height = "550px", "binH")),
             tabPanel("Quantile", 
                      metricsgraphicsOutput(height = "550px", "binQ"))))))
