\name{TH}
\alias{TH}
\title{
Sequential Goodness of Fit Testing for the Generalized Pareto Distribution
}
\description{
An implementation of the sequential testing procedure proposed in Thompson et al. (2009) for automated threshold selection
}
\usage{
TH(data, thresholds)
}
\arguments{
  \item{data}{vector of sample data}
  \item{thresholds}{a sequence of pre-defined thresholds to check for GPD assumption.}
}
\details{
The procedure proposed in Thompson et al. (2009) is based on sequential goodness of fit testing. First, one has to choose a equally spaced grid of posssible thresholds. The authors recommend 100 thresholds between the 50 percent and 98 percent quantile of the data, provided there are enough observations left (about 100 observations above the last pre-defined threshold). Then the parameters of a GPD for each threshold are estimated. One can show that the differences of subsequent scale parameters are approximately normal distributed. So a Pearson chi-squared test for normality is applied to all the differences, striking the smallest thresholds out until the test is not rejected anymore.
}
\value{
  \item{threshold}{the threshold used for the test}
  \item{num.above}{the number of observations above the given threshold}
  \item{p.values}{raw p-values for the thresholds tested}
  \item{ForwardStop}{transformed p-values according to the ForwardStop criterion. See G'Sell et al (2016) for more information}
  \item{StrongStop}{transformed p-values according to the StrongStop criterion. See G'Sell et al (2016) for more information}
  \item{est.scale}{estimated scale parameter for the given threshold}
  \item{est.shape}{estimated shape parameter for the given threshold}
}
\references{
Thompson, P. and Cai, Y. and Reeve, D. (2009)
Automated threshold selection methods for extreme wave analysis.
\emph{Coastal Engineering}, \bold{56}(10), 1013--1021.

G'Sell, M.G. and Wager, S. and Chouldechova, A. and Tibshirani, R. (2016)
Sequential selection procedures and false discovery rate control.
\emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)} \bold{78}(2), 423--444.
}
\examples{
data=rexp(1000)
u=seq(quantile(data,.1),quantile(data,.9),,100)
A=TH(data,u);A
}
