% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_mods.R
\name{pkmod3cptm}
\alias{pkmod3cptm}
\title{Solution to three-compartment IV model with effect-site}
\usage{
pkmod3cptm(
  tm,
  kR,
  pars,
  init = c(0, 0, 0, 0),
  inittm = 0,
  returncpt = c("all", "cpt1", "cpt2", "cpt3", "cpt4")
)
}
\arguments{
\item{tm}{Vector of times to evaluate the PK function at}

\item{kR}{Infusion rate (e.g. ml/min).}

\item{pars}{Named vector of parameters with names (k10,k12,k21,k13,k31,v1,v2,v3,ke0)}

\item{init}{Initial concentration}

\item{inittm}{Time of initiation of infusion}

\item{returncpt}{Optionally specify a single compartment to return concentrations for.
Defaults to returning all compartment concentrations.}
}
\description{
3 compartment IV infusion with first-order absorption between compartments and with an additional effect-site compartment.
The analytical solutions implemented in this function are provided in "ADVAN-style analytical solutions for common pharmacokinetic models" by
Abuhelwa et al. 2015.
}
\details{
This function takes in arguments for each of the absorption and elimination rate constants of a three-compartment model
as well as initial concentrations, c0. ke0 gives the rate of elimination from the effect-site compartment into the
central compartment (i.e. k41). The rate of absorption into the effect-site compartment is set at 1/10,000 the value of ke0.
The function returns a set of functions that calculate the concentration in each of the four compartments as a function of
time.
}
\examples{
pars_3cpt <- c(k10=1.5,k12=0.15,k21=0.09,k13=0.8,k31=0.8,v1=10,v2=15,v3=100,ke0=1)
pkmod3cptm(1,1,pars_3cpt)
}
