% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tci_algorithms.R
\name{tci_plasma}
\alias{tci_plasma}
\title{TCI algorithm for plasma targeting}
\usage{
tci_plasma(Cpt, pkmod, dtm, maxrt = 1200, cmpt = 1, ...)
}
\arguments{
\item{Cpt}{Target plasma concentration}

\item{pkmod}{PK model}

\item{dtm}{Duration of the infusion}

\item{maxrt}{Maximum infusion rate. Defaults to 200 ml/min in reference to the
maximum infusion rate of 1200 ml/h permitted by
existing TCI pumps (e.g. Anestfusor TCI program).}

\item{cmpt}{Compartment into which infusions are administered. Defaults to the first compartment.}

\item{...}{Arguments passed on to pkmod.}
}
\value{
Returns a numeric value with length one.
}
\description{
TCI algorithm based on the algorithm described by Jacobs (1990).
}
