% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get_gbifid.R
\name{get_gbifid}
\alias{as.data.frame.gbifid}
\alias{as.gbifid}
\alias{as.gbifid.character}
\alias{as.gbifid.data.frame}
\alias{as.gbifid.gbifid}
\alias{as.gbifid.list}
\alias{as.gbifid.numeric}
\alias{get_gbifid}
\alias{get_gbifid_}
\title{Get the GBIF backbone taxon ID from taxonomic names.}
\usage{
get_gbifid(sciname, ask = TRUE, verbose = TRUE, rows = NA)

as.gbifid(x, check = FALSE)

\method{as.gbifid}{gbifid}(x, check = FALSE)

\method{as.gbifid}{character}(x, check = TRUE)

\method{as.gbifid}{list}(x, check = TRUE)

\method{as.gbifid}{numeric}(x, check = TRUE)

\method{as.gbifid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{gbifid}(x, ...)

get_gbifid_(sciname, verbose = TRUE, rows = NA)
}
\arguments{
\item{sciname}{character; scientific name.}

\item{ask}{logical; should get_colid be run in interactive mode?
If TRUE and more than one ID is found for the species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; If TRUE the actual taxon queried is printed on the console.}

\item{rows}{numeric; Any number from 1 to inifity. If the default NA, all rows are considered.
Note that this function still only gives back a gbifid class object with one to many identifiers.
See \code{\link[taxize]{get_gbifid_}} to get back all, or a subset, of the raw data that you are
presented during the ask process.}

\item{x}{Input to \code{\link{as.gbifid}}}

\item{check}{logical; Check if ID matches any existing on the DB, only used in
\code{\link{as.gbifid}}}

\item{...}{Ignored}
}
\value{
A vector of unique identifiers. If a taxon is not found NA.
If more than one ID is found the function asks for user input.
}
\description{
Get the GBIF backbone taxon ID from taxonomic names.
}
\details{
Internally in this function we use a function to search GBIF's taxonomy,
and if we find an exact match we return the ID for that match. If there isn't an
exact match we return the options to you to pick from.
}
\examples{
\dontrun{
get_gbifid(sciname='Poa annua')
get_gbifid(sciname='Pinus contorta')
get_gbifid(sciname='Puma concolor')

# multiple names
get_gbifid(c("Poa annua", "Pinus contorta"))

# specify rows to limit choices available
get_gbifid(sciname='Pinus')
get_gbifid(sciname='Pinus', rows=10)
get_gbifid(sciname='Pinus', rows=1:3)

# When not found, NA given
get_gbifid(sciname="uaudnadndj")
get_gbifid(c("Chironomus riparius", "uaudnadndj"))

# Convert a uid without class information to a uid class
as.gbifid(get_gbifid("Poa annua")) # already a uid, returns the same
as.gbifid(get_gbifid(c("Poa annua","Puma concolor"))) # same
as.gbifid(2704179) # numeric
as.gbifid(c(2704179,2435099,3171445)) # numeric vector, length > 1
as.gbifid("2704179") # character
as.gbifid(c("2704179","2435099","3171445")) # character vector, length > 1
as.gbifid(list("2704179","2435099","3171445")) # list, either numeric or character
## dont check, much faster
as.gbifid("2704179", check=FALSE)
as.gbifid(2704179, check=FALSE)
as.gbifid(2704179, check=FALSE)
as.gbifid(c("2704179","2435099","3171445"), check=FALSE)
as.gbifid(list("2704179","2435099","3171445"), check=FALSE)

(out <- as.gbifid(c(2704179,2435099,3171445)))
data.frame(out)
as.uid( data.frame(out) )

# Get all data back
get_gbifid_("Puma concolor")
get_gbifid_(c("Pinus", "uaudnadndj"))
get_gbifid_(c("Pinus", "Puma"), rows=5)
get_gbifid_(c("Pinus", "Puma"), rows=1:5)
}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
\seealso{
\code{\link[taxize]{get_tsn}}, \code{\link[taxize]{get_uid}},
\code{\link[taxize]{get_tpsid}}, \code{\link[taxize]{get_eolid}},
\code{\link[taxize]{get_colid}}
}

