% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\docType{class}
\name{ASTMultiply}
\alias{ASTMultiply}
\title{The multiplication of two terms, as an ASTNode.}
\format{\code{\link{R6Class}} object.}
\usage{
ASTMultiply
}
\description{
The multiplication of two terms, as an ASTNode.
}
\section{Fields}{

\describe{
\item{\code{left}}{The AST tree to the left.}

\item{\code{right}}{The AST tree to the right.}
}}

\section{Methods}{

\describe{
  \item{\code{new(left, right)}}{Create addition node of given left and right node.}
  \item{\code{terms()}}{Returns the node as a term vector}
  \item{\code{factors()}}{Returns all terminal nodes under this as a list}
  \item{\code{distribute()}}{Applies the distributive property to the node, and returns the resulting node. This is the actual workhorse of the disributing multiplication across the tree.}
  \item{\code{string()}}{Returns the string formula of the node}
  \item{\code{reduce(data)}}{Given a set of data, perform the logical reduction of the current node.}
}
}

\examples{
ASTMultiply$new(ASTVariable$new("x"), ASTVariable$new("y"))$string()

}
\keyword{data}
