% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{load_vol}
\alias{load_vol}
\title{Loads ROI volumes from file for use by other functions}
\usage{
load_vol(filename, format = "voistat")
}
\arguments{
\item{filename}{(e.g. participant.voistat)}

\item{format}{(default is the TAC .voistat format from PMOD, also accepts 
"DFT and "BPndPaste")}
}
\value{
data.frame with loaded TAC data
}
\description{
Loads ROI volumes from file for use by other functions
}
\examples{
f_raw_vol <- system.file("extdata", "AD06_TAC.voistat", package="tacmagic")

vol <- load_vol(f_raw_vol)
}
\seealso{
Other Loading functions: \code{\link{as.tac}},
  \code{\link{load_tac}}, \code{\link{load_voistat}}
}
\concept{Loading functions}
