% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMatrix.R
\name{tableList}
\alias{tableList}
\title{tableList constructor}
\usage{
tableList(tabData, aidData = list())
}
\arguments{
\item{tabData}{A data.frame or a data.table.}

\item{aidData}{Aid structures, generally in the form of a list.}
}
\value{
A \code{tableList} object
}
\description{
\code{tableList} constructor, creates tableList object from a data.frame or a data.table
and from aid data. The goal is to wrap data.table and any additional data structures together. 
\code{tableList} behaves like a data.table object.
}
\examples{

data(chickwts)

# Bundle chickwts data.frame together with a linear model
TL <- tableList(chickwts, lm(weight~feed, chickwts))

# tableList behaves like a data.table  
mean(TL[feed=="casein", weight])

# Aid part of the tableList object carries the linear model
aid(TL)

}
\seealso{
\code{\link{dim.tableList}}, \code{\link{dimnames.tableList}}
   \code{\link{rbind.tableList}}
}

