% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.people.R
\name{trakt.show.people}
\alias{trakt.show.people}
\title{Get the cast and crew of a show}
\usage{
trakt.show.people(target, extended = "min")
}
\arguments{
\item{target}{The \code{id} of the show requested. Either the \code{slug}
(e.g. \code{"game-of-thrones"}), \code{trakt id} or \code{IMDb id}}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}}
}
\value{
A \code{list} containing \code{data.frame}s for cast and crew.
}
\description{
\code{trakt.show.people} pulls show people data.
}
\details{
Returns all cast and crew for a show, depending on how much data is available.
}
\note{
See \href{http://docs.trakt.apiary.io/#reference/shows/people/get-all-people-for-a-show}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
breakingbad.people <- trakt.show.people("breaking-bad")
}
}
\seealso{
Other people data: \code{\link{trakt.movie.people}};
  \code{\link{trakt.people.movies}};
  \code{\link{trakt.people.shows}};
  \code{\link{trakt.people.summary}}

Other show data: \code{\link{trakt.get_all_episodes}};
  \code{\link{trakt.get_full_showdata}};
  \code{\link{trakt.seasons.season}};
  \code{\link{trakt.seasons.summary}};
  \code{\link{trakt.show.ratings}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.show.watching}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.related}};
  \code{\link{trakt.shows.trending}};
  \code{\link{trakt.stats}}
}

