% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.seasons.R
\name{trakt.seasons.summary}
\alias{trakt.seasons.summary}
\title{Get a show's season information}
\usage{
trakt.seasons.summary(target, extended = "min", dropspecials = TRUE,
  dropunaired = TRUE)
}
\arguments{
\item{target}{The \code{id} of the show requested. Either the \code{slug}
(e.g. \code{"game-of-thrones"}), \code{trakt id} or \code{IMDb id}}

\item{extended}{Use \code{full,images} to get season posters. Can be
\code{min} (default), \code{images}, \code{full}, \code{full,images}}

\item{dropspecials}{If \code{TRUE} (default), special episodes (listed as 'season 0') are dropped}

\item{dropunaired}{If \code{TRUE} (default), seasons with \code{aired_episodes == 0} are dropped.
Only works if \code{extended} is set to more than \code{min}.}
}
\value{
A \code{data.frame} containing season details (nested in \code{list} objects)
}
\description{
\code{trakt.seasons.summary} pulls season data.
Get details for a show's seasons, e.g. how many seasons there are, how many epsiodes
each season has, and season posters.
See \href{http://docs.trakt.apiary.io/#introduction/extended-info}{the API docs} for possible values of
\code{extended} to customize output amount.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/seasons/summary}{the trakt API docs}
for further info
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
breakingbad.seasons <- trakt.seasons.summary("breaking-bad", extended = "min")
}
}
\seealso{
Other show data: \code{\link{trakt.get_all_episodes}};
  \code{\link{trakt.get_full_showdata}};
  \code{\link{trakt.seasons.season}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.ratings}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.show.watching}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.related}};
  \code{\link{trakt.shows.trending}};
  \code{\link{trakt.stats}}
}

