% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.trending.R
\name{trakt.movies.trending}
\alias{trakt.movies.trending}
\title{Get trending movies}
\usage{
trakt.movies.trending(limit = 10, page = 1, extended = "min")
}
\arguments{
\item{limit}{Number of movies to return. Is coerced to \code{integer} and must be greater than 0.}

\item{page}{Page to return (default is \code{1})
for \href{http://docs.trakt.apiary.io/#introduction/pagination}{pagination}.}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}}
}
\value{
A \code{data.frame} containing trending movies with their number of watchers, name and ids
}
\description{
\code{trakt.movies.trending} returns a list of trending movies on trakt.tv.
According to the API docs, it returns all movies being watched right now, where
movies with the most users are returned first.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/movies/trending/get-trending-movies}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
trakt.movies.trending(5)
}
}
\seealso{
Other aggregated data: \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.related}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.related}};
  \code{\link{trakt.shows.trending}}

Other movie data: \code{\link{trakt.movie.people}};
  \code{\link{trakt.movie.ratings}};
  \code{\link{trakt.movie.releases}};
  \code{\link{trakt.movie.summary}};
  \code{\link{trakt.movie.watching}};
  \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.related}};
  \code{\link{trakt.stats}}
}

