% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_visitor.R
\name{DoubleVisitor}
\alias{DoubleVisitor}
\alias{visitor_call}
\title{Double Visitor}
\usage{
DoubleVisitor(
  exprs,
  args,
  perform_cse = TRUE,
  llvm_opt_level = if (symengine_have_component("llvm")) 3L else -1L
)

visitor_call(visitor, input, do_transpose = FALSE)
}
\arguments{
\item{exprs}{A Basic object or a VecBasic object to be evaluated.}

\item{args}{A VecBasic object indicating order of input arguments. Can be missing.}

\item{perform_cse}{Boolean.}

\item{llvm_opt_level}{Integer. If negative, it will return a \code{LambdaDoubleVisitor},
otherwise it will return a \code{LLVMDoubleVisitor} with the specified optimization level.}

\item{visitor}{A DoubleVisitor object.}

\item{input}{A numeric matrix. Each row is input value for one argument.}

\item{do_transpose}{Boolean. Matters when \code{exprs} is a VecBasic.
If true, output will have each column for one symbolic expression, otherwise
each row for one symbolic expression.}
}
\value{
\code{DoubleVisitor} returns a callable \code{LambdaDoubleVisitor} or
  \code{LLVMDoubleVisitor}. \code{visitor_call} returns a numeric vector or matrix.
}
\description{
Construct \code{DoubleVisitor} object from \code{Basic} or \code{VecBasic}
and use it to numerically evaluate symbolic expressions.
}
\details{
\code{DoubleVisitor} constructs the visitor and visitor itself is callable.
\code{visitor_call} is the low level function to call the visitor with input.
}
\examples{
a <- S("a")
b <- S("b")
c <- S("c")
vec <- c(log(a), log(a)/log(b) + c)
func <- DoubleVisitor(vec, args = c(a, b, c))
args(func)

## Use closure
func(a = 1:10, b = 10:1, c = 1.43)

## Use visitor_call
input <- rbind(a = 1:10, b = 10:1, c = 1.43)
visitor_call(func, input, do_transpose = TRUE)
}
\seealso{
\code{\link{lambdify}}.
}
