% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{switchTo}
\alias{switchTo}
\alias{switchTo,SwitchrCtx,ANY}
\alias{switchTo,SwitchrCtx,ANY-method}
\alias{switchTo,character,PkgManifest}
\alias{switchTo,character,PkgManifest-method}
\alias{switchTo,character,RepoSubset}
\alias{switchTo,character,RepoSubset-method}
\alias{switchTo,character,SessionManifest}
\alias{switchTo,character,SessionManifest-method}
\alias{switchTo,character,SwitchrCtx}
\alias{switchTo,character,SwitchrCtx-method}
\alias{switchTo,character,character}
\alias{switchTo,character,character-method}
\alias{switchTo,character,missing}
\alias{switchTo,character,missing-method}
\title{switchTo}
\usage{
switchTo(name, seed = NULL, reverting = FALSE, ignoreRVersion = FALSE,
  ...)

\S4method{switchTo}{character,character}(name, seed = NULL,
  reverting = FALSE, ignoreRVersion = FALSE, ...)

\S4method{switchTo}{character,SwitchrCtx}(name, seed = NULL,
  reverting = FALSE, ignoreRVersion = FALSE, ...)

\S4method{switchTo}{character,missing}(name, seed = NULL, reverting = FALSE,
  ignoreRVersion = FALSE, ...)

\S4method{switchTo}{SwitchrCtx,ANY}(name, seed = NULL, reverting = FALSE,
  ignoreRVersion = FALSE, ...)

\S4method{switchTo}{character,RepoSubset}(name, seed = NULL,
  reverting = FALSE, ignoreRVersion = FALSE, ...)

\S4method{switchTo}{character,PkgManifest}(name, seed = NULL,
  reverting = FALSE, ignoreRVersion = FALSE, ...)

\S4method{switchTo}{character,SessionManifest}(name, seed = NULL,
  reverting = FALSE, ignoreRVersion = FALSE, ...)
}
\arguments{
\item{name}{The name associated (or to associate) with the computing
environment.}

\item{seed}{The seed, indicating packages to install into a newly created
package library
No effect if the library already exists}

\item{reverting}{Indicates whether we are reverting to the environment in
use before the current one. Typically not set directly by the user.}

\item{ignoreRVersion}{Should the R version in use be ignored when checking
for existing computing environmeSnts. This is experimental.}

\item{...}{Passed directly to \code{installCompEnv} if an existing
computing environment is not found.}
}
\value{
Invisibly returns the SwitchrCtx object representing the new
computing environment
}
\description{
Switch to a different computing environment (set of installed R packages
and library location paths for new pkg installs)
}
\details{
If switchr does not now about the specified computing environment, a new one
will be created via installCompEnv. This includes
creating a directory under the switchr base directory and installing
packages into it. See \code{installCompEnv} for more details.

This function has the side effect of unloading all loaded
packages (other than base packages, GRAN or GRANBAse,  switchr itself, and
switchr's dependencies) and the associated DLLs. It also changes the library
location R will use to search for packages, e.g. when you call
\code{library}.

This means you will have to reinstall packages after switching, which is
important and intended (e.g. when switching to using Bioc devel from Bioc
release).
}
\examples{
\dontrun{
switchTo("mynewlibrary")
switchBack()

fdman = GithubManifest("gmbecker/fastdigest")
switchTo("fastdigestlib", seed = fdman)
}
}

