% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan2list.R
\name{stan2list}
\alias{stan2list}
\title{Convert STAN posterior to list}
\usage{
stan2list(x, collapse.chains = TRUE)
}
\arguments{
\item{x}{list of class `stan`. The output from a call to 
\link[rstan]{stan}.}

\item{collapse.chains}{return array with dimension for each chain?}
}
\description{
Convert `stan` posterior to named list of vectors or arrays.
}
\note{
If \code{collapse.chains = TRUE}, the last dimension of arrays will always 
  be samples from the posterior. If \code{collapse.chains = FALSE}, the last 
  dimension of arrays will be individual chains, and the one prior to that 
  will be samples from the posterior for each chain.
}
\seealso{
\link[base]{aperm} to transpose the array if necessary.   
  \link[base]{as.data.frame.table} to convert arrays to data.frames.
}
