% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sn.params.R
\name{sn.params}
\alias{sn.params}
\alias{sn.location}
\alias{sn.mean}
\alias{sn.mode}
\alias{sn.variance}
\alias{sn.skewness}
\alias{sn.delta}
\alias{sn.m0}
\title{Skew-Normal parameter computation}
\usage{
sn.location(mode, scale, shape)

sn.mean(dp)

sn.mode(dp)

sn.variance(scale, shape)

sn.skewness(shape)

sn.delta(shape)

sn.m0(shape)
}
\arguments{
\item{mode}{mode of skew normal distribution.}

\item{scale}{skew normal scale parameter.}

\item{shape}{skew normal shape parameter.}

\item{dp}{3 element vector of (in order) location, scale, and shape parameters.}
}
\value{
\tabular{ll}{
  \code{sn.location} \tab location parameter computed from mode, scale, and shape.\cr
  \code{sn.mean} \tab mean of the skew normal distribution.\cr
  \code{sn.mode} \tab mode of the skew normal distribution.\cr
  \code{sn.variance} \tab variance of the skew normal distribution.\cr
  \code{sn.skewness} \tab skewness of the skew normal distribution.\cr
  \code{sn.delta} \tab value used in other moment computations.\cr
  \code{sn.m0} \tab value used in mode computation.
}
}
\description{
Compute parameters and moments of skew normal distribution.
}
\references{
\url{https://en.wikipedia.org/wiki/Skew_normal_distribution}
}
\seealso{
\code{sn} package by Adelchi Azzalini for skew normal 
PDF and CDF functions.\cr
Azzalini, A. with the collaboration of Capitanio, A. (2014). 
The Skew-Normal and Related Families. Cambridge University Press, 
IMS Monographs series.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
