% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_variable_response.R
\name{plot.surv_variable_response_explainer}
\alias{plot.surv_variable_response_explainer}
\title{Plot for surv_variable_response object}
\usage{
\method{plot}{surv_variable_response_explainer}(x, ..., split = "model")
}
\arguments{
\item{x}{an object of class "surv_variable_response"}

\item{...}{other arguments}

\item{split}{a character, either "model" or "variable"; sets the variable for faceting}
}
\description{
Function plot for surv_variable_response object shows the expected output condition on a selected variable.
}
\examples{
\donttest{
library(survxai)
library(rms)
data("pbcTest")
data("pbcTrain")
predict_times <- function(model, data, times){
                  prob <- rms::survest(model, data, times = times)$surv
                  return(prob)
                  }
cph_model <- cph(Surv(years, status)~., data=pbcTrain, surv=TRUE, x = TRUE, y=TRUE)
surve_cph <- explain(model = cph_model, data = pbcTest[,-c(1,5)], 
             y = Surv(pbcTest$years, pbcTest$status), predict_function = predict_times)
svr_cph <- variable_response(surve_cph, "sex")
plot(svr_cph)
}

}
