% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkInputs.R
\name{checkInputs}
\alias{checkInputs}
\title{Check Function Inputs}
\usage{
checkInputs(ftime, ftype, trt, adjustVars, t0 = max(ftime[ftype > 0]),
  SL.ftime = NULL, SL.ctime = NULL, SL.trt = NULL, glm.ftime = NULL,
  glm.ctime = NULL, glm.trt = "1", returnIC = TRUE, returnModels = TRUE,
  ftypeOfInterest = unique(ftype[ftype != 0]), trtOfInterest = unique(trt),
  method = "hazard", bounds = NULL, verbose = FALSE,
  tol = 1/(length(ftime)), maxIter = 100, Gcomp = FALSE)
}
\arguments{
\item{ftime}{A numeric vector of failure times. Right-censored observations
should have corresponding \code{ftype} set to 0.}

\item{ftype}{A numeric vector indicating the type of failure. Observations
with \code{ftype == 0} are treated as right-censored. Each unique
value besides zero is treated as a separate type of failure.}

\item{trt}{A numeric vector indicating observed treatment assignment. Each
unique value will be treated as an (unordered) separate type of
treatment. Currently, only two unique values of \code{trt} are
supported.}

\item{adjustVars}{A \code{data.frame} of adjustment variables that will be
used in estimating the conditional treatment, censoring, and failure
(hazard or conditional mean) probabilities.}

\item{t0}{The time at which to return cumulative incidence estimates. By
default this is set to \code{max(ftime)}.}

\item{SL.ftime}{A character vector or list specification to be passed to the
\code{SL.library} argument in the call to \code{SuperLearner} for the
outcome regression (either cause-specific hazards or conditional mean).
See \code{?SuperLearner} for more information on how to specify valid
\code{SuperLearner} libraries. It is expected that the wrappers used
in the library will play nicely with the input variables, which will
be called \code{"trt"} and \code{names(adjustVars)}.}

\item{SL.ctime}{A character vector or list specification to be passed to the
\code{SL.library} argument in the call to \code{SuperLearner} for the
estimate of the conditional hazard for censoring. It is expected that
the wrappers used in the library will play nicely with the input
variables, which will be called \code{"trt"} and
\code{names(adjustVars)}.}

\item{SL.trt}{A character vector or list specification to be passed to the
\code{SL.library} argument in the call to \code{SuperLearner} for the
estimate of the conditional probability of treatment. It is expected
that the wrappers used in the library will play nicely with the input
variables, which will be \code{names(adjustVars)}.}

\item{glm.ftime}{A character specification of the right-hand side of the
equation passed to the \code{formula} option of a call to \code{glm}
for the outcome regression (either cause-specific hazards or
conditional mean). Ignored if \code{SL.ftime != NULL}. Use \code{"trt"}
to specify the treatment in this formula (see examples). The formula
can additionally include any variables found in
\code{names(adjustVars)}.}

\item{glm.ctime}{A character specification of the right-hand side of the
equation passed to the \code{formula} option of a call to \code{glm}
for the estimate of the conditional hazard for censoring. Ignored if
\code{SL.ctime != NULL}. Use \code{"trt"} to specify the treatment in
this formula (see examples). The formula can additionally include any
variables found in \code{names(adjustVars)}.}

\item{glm.trt}{A character specification of the right-hand side of the
equation passed to the \code{formula} option of a call to \code{glm}
for the estimate of the conditional probability of treatment. Ignored
if \code{SL.trt != NULL}. By default set to "1", corresponding to
using empirical estimates of each value of \code{trt}. The formula can
include any variables found in \code{names(adjustVars)}.}

\item{returnIC}{A boolean indicating whether to return vectors of influence
curve estimates. These are needed for some post-hoc comparisons, so it
is recommended to leave as \code{TRUE} (the default) unless the user
is sure these estimates will not be needed later.}

\item{returnModels}{A boolean indicating whether to return the
\code{SuperLearner} or \code{glm} objects used to estimate the
nuisance parameters. Must be set to \code{TRUE} if the user plans to
use calls to \code{timepoints} to obtain estimates at times other
than \code{t0}. See \code{?timepoints} for more information.}

\item{ftypeOfInterest}{An input specifying what failure types to compute
estimates of incidence for. The default value computes estimates for
values \code{unique(ftype)}. Can alternatively be set to a vector of
values found in \code{ftype}.}

\item{trtOfInterest}{An input specifying which levels of \code{trt} are of
interest. The default value computes estimates for values
\code{unique(trt)}. Can alternatively be set to a vector of values
found in \code{trt}.}

\item{method}{A character specification of how the targeted minimum
loss-based estimators should be computer, either \code{"mean"} or
\code{"hazard"}. The \code{"mean"} specification uses a closed-form
targeted minimum loss-based estimation based on the G-computation
formula of Bang and Robins (2005). The \code{"hazard"} specification
uses an iteratively algorithm based on cause-specific hazard functions.
The latter specification has no guarantee of convergence in finite
samples. The convergence can be influenced by the stopping criteria
specified in the \code{tol}. Future versions may implement a closed
form version of this hazard-based estimator.}

\item{bounds}{A list of bounds.}

\item{verbose}{A boolean indicating whether the function should print
messages to indicate progress.}

\item{tol}{The stopping criteria when \code{method = "hazard"}. The algorithm
will continue performing targeting updates to the initial estimators
until the empirical mean of the efficient influence function is
smaller than \code{tol}. The default (\code{1/length(ftime)}) is a
sensible value. Larger values can be used in situations where
convergence of the algorithm is an issue; however, this may result in
large finite-sample bias.}

\item{maxIter}{A maximum number of iterations for the algorithm when
\code{method = "hazard"}. The algorithm will iterate until either the
empirical mean of the efficient influence function is smaller than
\code{tol} or until \code{maxIter} iterations have been completed.}

\item{Gcomp}{A boolean indicating whether to compute the G-computation
estimator (i.e., a substitution estimator with no targeting step).
Note, theory does not support inference for the G-computation
estimator if Super Learner is used to estimate failure and censoring
mechanisms. Only implemented for \code{method = "mean"}.}
}
\value{
Options to be passed to \code{mean_tmle} or \code{hazard_tmle}.
}
\description{
Check the input values of function parameters for errors.
}
