% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multidf.R
\name{multidf}
\alias{multidf}
\title{Create a multidf object}
\usage{
multidf(gap1, gap2, gap3=NULL, event1, status, event2=NULL, ...)
}
\arguments{
\item{gap1}{First gap time.}

\item{gap2}{Second gap time.}

\item{gap3}{Third gap time. By default is NULL.}

\item{event1}{Indicator of the first time; 0 if the first time is censored 
and 1 otherwise.}

\item{status}{Censoring indicator of the survival time of the process; 0 if 
the total time is censored and 1 otherwise. For instance, for three gap times,
status is given by the indicator of the third time.}

\item{event2}{Indicator of the second time; 0 if the first time is censored 
and 1 otherwise. By default is NULL.}

\item{...}{Other options. Additional arguments, such as covariates, can also 
be included  in the data set.}
}
\value{
An object of class "multidf". "multidf" objects are implemented as a
single data frame.
}
\description{
Creates a "multidf" object, usually used as a response variable 
in a model formula.
}
\details{
Arguments in this function must be introduced in the following
order: \code{gap1}, \code{event1}, \code{gap2} and \code{status}, where
\code{gap1} and \code{gap2} are ordered event times and
\code{event1} and \code{status} their corresponding indicator statuses.
Other arguments can be also added. These should consider intermediate times 
and corresponding censoring indicators or covariates.
}
\examples{
library(survivalREC)
data("bladder4state")

b3state<-multidf(gap1=bladder4state$y1, event1=bladder4state$d1, 
                 gap2=bladder4state$y2, status=bladder4state$d2, 
                 size=bladder4state$size) 

head(b3state[[1]])

class(b3state)

b4state<-multidf(gap1=bladder4state$y1, event1=bladder4state$d1, 
                 gap2=bladder4state$y2, event2=bladder4state$d2,
                 gap3=bladder4state$y3, status=bladder4state$d3, 
                 size=bladder4state$size)

head(b4state[[1]])

}
\author{
Gustavo Soutinho and Luis Meira-Machado
}
