% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_info.R
\name{surv_model_info}
\alias{surv_model_info}
\alias{surv_model_info.coxph}
\alias{surv_model_info.rfsrc}
\alias{surv_model_info.ranger}
\alias{surv_model_info.model_fit}
\alias{surv_model_info.cph}
\alias{surv_model_info.LearnerSurv}
\alias{surv_model_info.default}
\title{Extract additional information from the model}
\usage{
surv_model_info(model, ...)

\method{surv_model_info}{coxph}(model, ...)

\method{surv_model_info}{rfsrc}(model, ...)

\method{surv_model_info}{ranger}(model, ...)

\method{surv_model_info}{model_fit}(model, ...)

\method{surv_model_info}{cph}(model, ...)

\method{surv_model_info}{LearnerSurv}(model, ...)

\method{surv_model_info}{default}(model, ...)
}
\arguments{
\item{model}{\itemize{
\item model object
}}

\item{...}{\itemize{
\item other arguments
}}
}
\value{
A named list of class \code{model_info}
}
\description{
This generic function let user extract base information about model. The function returns a named list of class \code{model_info} that
contain information about package of model, version and task type. For wrappers like \code{mlr} or \code{parsnip} both, package and wrapper
information are stored
}
\details{
Currently supported packages are:
\itemize{
\item class \code{coxph} - Cox proportional hazards regression model created with \pkg{survival} package
\item class \code{model_fit} - models created with \pkg{parsnip} package
\item class \code{ranger} - random survival forest models created with \pkg{ranger} package
\item class \code{rfsrc} - random forest models created with \pkg{randomForestSRC} package
}
}
\examples{
library(survival)
library(survex)
cph <- survival::coxph(survival::Surv(time, status) ~ ., data = veteran,
                       model = TRUE, x = TRUE, y = TRUE)
surv_model_info(cph)

\donttest{
library(ranger)
rsf_ranger <- ranger::ranger(survival::Surv(time, status) ~ ., data = veteran,
 num.trees = 50, mtry = 3, max.depth = 5)
surv_model_info(rsf_ranger)
}

}
