% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_00.r
\name{NR.beta}
\alias{NR.beta}
\title{Inner Newton-Raphson algorithm for regression parameters estimation}
\usage{
NR.beta(build, beta.ini, detail.beta, max.it.beta = 200,
  tol.beta = 1e-04)
}
\arguments{
\item{build}{list of objects returned by \code{\link{model.cons}}}

\item{beta.ini}{vector of initial regression parameters; default is NULL, in which case the first beta will be \code{log(sum(event)/sum(t1))} and the others will be zero (except if there are "by" variables in which case all betas are set to zero)}

\item{detail.beta}{if TRUE, details concerning the optimization process in the regression parameters are displayed; default is FALSE}

\item{max.it.beta}{maximum number of iterations to reach convergence in the regression parameters; default is 200}

\item{tol.beta}{convergence tolerance for regression parameters; default is \code{1e-04}}
}
\value{
List of objects:
\item{beta}{estimated regression parameters}
\item{ll.unpen}{log-likelihood at convergence}
\item{ll}{penalized log-likelihood at convergence}
\item{haz.GL}{list of all the matrix-vector multiplications X.GL[[i]]\%*\%beta for Gauss Legendre integration. Useful to avoid repeating operations in \code{\link{survPen.fit}}}
\item{iter.beta}{number of iterations needed to converge}
}
\description{
Applies Newton-Raphson algorithm for beta estimation. Two specific modifications aims at guaranteeing
convergence : first the hessian is perturbed whenever it is not positive definite and second, at each step, if the penalized
log-likelihood is not maximized, the step is halved until it is.
}
\details{
If we note \code{ll} and \code{beta} respectively the current penalized log-likelihood and estimated parameters and
\code{llold} and \code{betaold} the previous ones, the algorithm goes on while
(abs(ll-llold)>tol.beta) or any(abs((beta-betaold)/betaold)>tol.beta)
}
