% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KMeansTrainer.R
\docType{data}
\name{KMeansTrainer}
\alias{KMeansTrainer}
\title{K-Means Trainer}
\format{\code{\link{R6Class}} object.}
\usage{
KMeansTrainer
}
\description{
Trains am unsupervised K-Means algorithm. It borrows mini-batch k-means function from
ClusterR r package which is written in c++, hence it is quite fast.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
kmt = KMeansTrainer$new(n_estimators, max_features, max_depth, min_node_size, criterion,classification, class_weights, verbose, seed,always_split)
bst$fit(X_train, y_train)
prediction <- bst$predict(X_test)
}
}

\section{Methods}{

\describe{
  \item{\code{$new()}}{Initialises an instance of k-means model}
  \item{\code{$fit()}}{fit model to an input train data}
  \item{\code{$predict()}}{returns cluster predictions for each row of given data}
}
}

\section{Arguments}{

\describe{
 \item{params}{for explanation on parameters, please refer to the documentation of MiniBatchKMeans function in clusterR package \url{https://CRAN.R-project.org/package=ClusterR}}
 \item{find_optimal}{Used to find the optimal number of cluster during \code{fit} method. To use this, make sure the value for /code{max_cluster} > 0.}
}
}

\examples{
data <- rbind(replicate(20, rnorm(1e5, 2)),
             replicate(20, rnorm(1e5, -1)),
             replicate(20, rnorm(1e5, 5)))
km_model <- KMeansTrainer$new(clusters=2, batch_size=30, max_clusters=6)
km_model$fit(data, find_optimal = FALSE)
predictions <- km_model$predict(data)
}
\keyword{datasets}
