% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctable.R
\name{ctable}
\alias{ctable}
\title{Cross-Tabulation}
\usage{
ctable(
  x,
  y,
  prop = st_options("ctable.prop"),
  useNA = "ifany",
  totals = st_options("ctable.totals"),
  style = st_options("style"),
  round.digits = 1,
  justify = "right",
  plain.ascii = st_options("plain.ascii"),
  headings = st_options("headings"),
  display.labels = st_options("display.labels"),
  split.tables = Inf,
  dnn = c(substitute(x), substitute(y)),
  chisq = FALSE,
  weights = NA,
  rescale.weights = FALSE,
  ...
)
}
\arguments{
\item{x}{First categorical variable - values will appear as row names.}

\item{y}{Second categorical variable - values will appear in as column names.}

\item{prop}{Proportions to display;  \dQuote{r} for \emph{rows} (default),
\dQuote{c} for \emph{columns}, \dQuote{t} for \emph{total}, or \dQuote{n} 
for \emph{none}. This option can be set globally; see 
\code{\link{st_options}}.}

\item{useNA}{Argument passed on to \code{\link[base]{table}}; One of 
\dQuote{ifany} (default), \dQuote{no}, or \dQuote{always}.}

\item{totals}{Logical. Should row and column totals be displayed? Defaults to
\code{TRUE}. To change this default value globally, see
\code{\link{st_options}}.}

\item{style}{Style to be used by \code{\link[pander]{pander}} when rendering
output table; One of \dQuote{simple} (default), \dQuote{grid}, or 
\dQuote{rmarkdown}. This option can be set globally; 
see \code{\link{st_options}}.}

\item{round.digits}{Number of significant digits to display. Defaults to
\code{1}. To change this default value globally, see 
\code{\link{st_options}}.}

\item{justify}{String indicating alignment of columns; one of \dQuote{l} 
(left) \dQuote{c} (center), or \dQuote{r} (right). Defaults to \dQuote{r}.}

\item{plain.ascii}{Logical. \code{\link[pander]{pander}} argument; when
\code{TRUE}, no markup characters will be used (useful when printing
to console). Defaults to \code{TRUE} unless \code{style = 'rmarkdown'},
in which case it will be set to \code{FALSE} automatically. To change the 
default value globally, use \code{\link{st_options}}.}

\item{headings}{Logical. Set to \code{FALSE} to omit heading section. Can be
set globally via \code{\link{st_options}}.}

\item{display.labels}{Logical. Should variable / data frame label be 
displayed in the title section? Default is \code{TRUE}. To change this
default value globally, use \code{\link{st_options}}.}

\item{split.tables}{Pander argument that specifies how many characters wide a
table can be. \code{Inf} by default.}

\item{dnn}{Names to be used in output table. Vector of two strings; By 
default, the character values for arguments x and y are used.}

\item{chisq}{Logical. Display chisq statistic along with p-value in a message.}

\item{weights}{Vector of weights; must be of the same length as \code{x}.}

\item{rescale.weights}{Logical parameter. When set to \code{TRUE}, the total
count will be the same as the unweighted \code{x}. \code{FALSE} by default.}

\item{\dots}{Additional arguments passed to \code{\link[pander]{pander}}.}
}
\value{
A frequency table of classes \code{matrix} and \code{summarytools} 
  with added attributes used by \link{print} method.
}
\description{
Cross-tabulation for a pair of categorical variables (or factors) with either
row, column, or total proportions, as well as marginal sums.
}
\details{
Rmarkdown does not, to this day, support multi-header tables. 
  Therefore, until such support is available, the recommended way to display 
  cross-tables in .Rmd documents is to use `method=render` with the `print()`
  or `view()` functions. See package vignettes for examples.
}
\examples{
data("tobacco")
ctable(tobacco$gender, tobacco$smoker)

# Use with() to simplify syntax
with(tobacco, ctable(smoker, diseased))

# Show column proportions, without totals
with(tobacco, ctable(smoker, diseased, prop = "c", totals = FALSE))

# Simple 2 x 2 table
with(tobacco, ctable(gender, smoker, totals = FALSE, headings = FALSE, prop = "n"))

# Grouped cross-tabulations
with(tobacco, stby(list(x = smoker, y = diseased), gender, ctable))

\dontrun{
ct <- ctable(tobacco$gender, tobacco$smoker)

# Show html results in browser
print(ct, method = "browser")

# Save results to html file
print(ct, file = "ct_gender_smoker.html")

# Save results to text file
print(ct, file = "ct_gender_smoker.txt")
}
}
\seealso{
\code{\link[base]{table}}, \code{\link[stats]{xtabs}}
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{category}
\keyword{classes}
