% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/file_io.R
\name{clustering_to_file}
\alias{clustering_to_file}
\title{Write a Subspace Clustering to Disk}
\usage{
clustering_to_file(clustering, file_path, index_should_start_at = 0)
}
\arguments{
\item{clustering}{a subspace clustering object as generated by one of the
functions from the \emph{subspace} package}

\item{file_path}{the path to the file into which the clustering should be
written}

\item{index_should_start_at}{the value that is used to refer to the first
value in the dataset.}
}
\description{
Write a Subspace Clustering to Disk
}
\note{
By default, R uses the value \emph{1} when referring to the first object
 in a data frame or array, while most other languages use \emph{0}. To make
 working with this convention easy, clusterings written to disk are converted
 to this 0-indexing System. The standard parameter for the corresponding
 function \code{\link{clustering_from_file}} is set in such a way that files
 read will automatically be converted to 1-indexes, which means that you
 should never need to change this parameter if you work exclusively with the
 \emph{subspace} package.
}
\seealso{
\code{\link{clustering_from_file}}
}

