% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested-to-tree.R
\name{create_node_from_nested_root}
\alias{create_node_from_nested_root}
\title{Convert a nested data frame into a node tree}
\usage{
create_node_from_nested_root(pd_nested, structure_only)
}
\arguments{
\item{pd_nested}{A nested data frame.}

\item{structure_only}{Whether or not create a tree that represents the
structure of the expression without any information on the tokens. Useful
to check whether two structures are identical.}
}
\value{
An object of class "Node" and "R6".
}
\description{
This function is convenient to display all nesting levels of a nested data frame
at once.
}
\examples{
if (rlang::is_installed("data.tree")) {
  withr::with_options(
    list(styler.cache_name = NULL), # temporarily deactivate cache
    {
      code <- "a <- function(x) { if(x > 1) { 1+1 } else {x} }"
      nested_pd <- styler:::compute_parse_data_nested(code)
      initialized <- styler:::pre_visit_one(
        nested_pd, default_style_guide_attributes
      )
      styler:::create_node_from_nested_root(initialized,
        structure_only = FALSE
      )
    }
  )
}
}
\keyword{internal}
