% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{transform_and_check}
\alias{transform_and_check}
\title{Transform a file an check the result}
\usage{
transform_and_check(in_item, out_item, in_name = in_item,
  out_name = out_item, transformer, write_back, write_tree = NA,
  out_tree = "_tree", ...)
}
\arguments{
\item{in_item}{An path to an file to transform.}

\item{out_item}{The path to a file that contains the expected result.}

\item{in_name}{The label of the in_item, defaults to \code{in_item}.}

\item{out_name}{The label of the out_item, defaults to \code{out_item}.}

\item{transformer}{A function to apply to the content of \code{in_item}.}

\item{write_back}{Whether the results of the transformation should be written
to the output file.}

\item{write_tree}{Whether or not the tree structure of the test should be
computed and written to a file. Note that this needs R >= 3.2
(see \code{\link[=set_arg_write_tree]{set_arg_write_tree()}}). If the argument is set to \code{NA}, the function
determines whether R >= 3.2 is in use and if so, trees will be written.}

\item{out_tree}{Name of tree file if written out.}

\item{...}{Parameters passed to transformer function.}
}
\description{
Transform an file and check whether it is identical to a reference.
}
\keyword{internal}
